/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.expr;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aksw.commons.collections.SetUtils;
import org.aksw.jenax.arq.util.expr.ClauseUtils;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public class NfUtils {
    public static Set<Var> getVarsMentioned(Iterable<? extends Iterable<? extends Expr>> clauses) {
        HashSet<Var> result = new HashSet<Var>();
        for (Iterable<? extends Expr> iterable : clauses) {
            Set<Var> tmp = ClauseUtils.getVarsMentioned(iterable);
            result.addAll(tmp);
        }
        return result;
    }

    public static Set<Set<Expr>> canonicalize(Iterable<? extends Iterable<? extends Expr>> clauses) {
        Set<Set<Expr>> result = StreamSupport.stream(clauses.spliterator(), false).map(clause -> ClauseUtils.signaturize(clause)).collect(Collectors.toSet());
        return result;
    }

    public static Multimap<Set<Expr>, Set<Expr>> createStructuralEquivalenceClasses(Iterable<? extends Iterable<? extends Expr>> clauses) {
        HashMultimap result = HashMultimap.create();
        for (Iterable<? extends Expr> iterable : clauses) {
            Set<Expr> clazz = ClauseUtils.signaturize(iterable);
            result.put(clazz, (Object)SetUtils.asSet((Iterable)((Set)iterable)));
        }
        return result;
    }
}

