/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.cache;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.util.TupleCmp;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.tuple.adapter.TupleBridgeQuad;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;

public class CachePattern {
    public static final Var IN = Var.alloc((String)"IN");
    protected Quad specPattern;
    protected Quad findPattern;
    protected int[] inputs;

    protected CachePattern(Quad specPattern, Quad findPattern, int[] inputs) {
        this.specPattern = specPattern;
        this.findPattern = findPattern;
        this.inputs = inputs;
    }

    public Quad getSpecPattern() {
        return this.specPattern;
    }

    public Quad getFindPattern() {
        return this.findPattern;
    }

    public int[] getInputs() {
        return this.inputs;
    }

    public Tuple<Node> createPartitionKey(Quad quad) {
        Object[] arr = new Node[this.inputs.length];
        for (int i = 0; i < this.inputs.length; ++i) {
            int idx = this.inputs[i];
            arr[i] = QuadUtils.getNode(quad, idx);
        }
        Tuple result = TupleFactory.create((Object[])arr);
        return result;
    }

    public Tuple<Node> createPartitionKey(Node mg, Node ms, Node mp, Node mo) {
        return this.createPartitionKey(QuadUtils.createMatch(mg, ms, mp, mo));
    }

    public boolean matchesPattern(Node mg, Node ms, Node mp, Node mo) {
        return this.matchesPattern(new Node[]{mg, ms, mp, mo}, (arr, i) -> arr[i]);
    }

    public boolean subsumes(Quad quad) {
        return this.subsumes((Object)quad, (TupleAccessor)TupleBridgeQuad.get());
    }

    public boolean subsumes(Node mg, Node ms, Node mp, Node mo) {
        return this.subsumes(new Node[]{mg, ms, mp, mo}, (arr, i) -> arr[i]);
    }

    public <D> boolean matchesPattern(D argPattern, TupleAccessor<D, Node> accessor) {
        boolean result = TupleCmp.matches((int)4, CachePattern::matchesPatternNode, (Object)this.specPattern, (TupleAccessor)TupleBridgeQuad.get(), argPattern, accessor);
        return result;
    }

    public <D> boolean subsumes(D argPattern, TupleAccessor<D, Node> accessor) {
        boolean result = TupleCmp.matches((int)4, CachePattern::subsumes, (Object)this.specPattern, (TupleAccessor)TupleBridgeQuad.get(), argPattern, accessor);
        return result;
    }

    public static boolean matchesPatternNode(Node patternNode, Node argNode) {
        boolean result = IN.equals((Object)patternNode) ? argNode.isConcrete() : (Node.ANY.equals((Object)patternNode) ? Node.ANY.equals((Object)argNode) : patternNode.equals((Object)argNode));
        return result;
    }

    public static boolean subsumes(Node patternNode, Node argNode) {
        boolean result = IN.equals((Object)patternNode) ? argNode.isConcrete() : (Node.ANY.equals((Object)patternNode) ? true : patternNode.equals((Object)argNode));
        return result;
    }

    public static CachePattern create(Node g, Node s, Node p, Node o) {
        Quad specPattern = QuadUtils.createMatch(g, s, p, o);
        int[] inputs = IntStream.range(0, 4).filter(i -> IN.equals((Object)QuadUtils.getNode(specPattern, i))).toArray();
        Quad findPattern = QuadUtils.create((Node[])QuadUtils.streamNodes(specPattern).map(n -> IN.equals(n) ? Node.ANY : n).toArray(Node[]::new));
        return new CachePattern(specPattern, findPattern, inputs);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.inputs);
        result = 31 * result + Objects.hash(this.findPattern, this.specPattern);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachePattern other = (CachePattern)obj;
        return Objects.equals(this.findPattern, other.findPattern) && Arrays.equals(this.inputs, other.inputs) && Objects.equals(this.specPattern, other.specPattern);
    }

    public String toString() {
        return "CachePattern [specPattern=" + String.valueOf(this.specPattern) + ", findPattern=" + String.valueOf(this.findPattern) + ", inputs=" + Arrays.toString(this.inputs) + "]";
    }
}

