/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple.adapter;

import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge4;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.tuple.QuadAccessor;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;

public class TupleBridgeQuad
implements TupleBridge4<Quad, Node> {
    public static final TupleBridgeQuad INSTANCE = new TupleBridgeQuad();

    public static TupleBridgeQuad get() {
        return INSTANCE;
    }

    public int getDimension() {
        return 4;
    }

    public Node get(Quad quad, int idx) {
        return QuadUtils.getNode(quad, idx);
    }

    public Quad build(Node g, Node s, Node p, Node o) {
        return Quad.create((Node)g, (Node)s, (Node)p, (Node)o);
    }

    public static <X, C> C getGraph(X tuple, TupleAccessor<? super X, ? extends C> accessor) {
        return (C)accessor.get(tuple, 0);
    }

    public static <X, C> C getSubject(X tuple, TupleAccessor<? super X, ? extends C> accessor) {
        return (C)accessor.get(tuple, 1);
    }

    public static <X, C> C getPredicate(X tuple, TupleAccessor<? super X, ? extends C> accessor) {
        return (C)accessor.get(tuple, 2);
    }

    public static <X, C> C getObject(X tuple, TupleAccessor<? super X, ? extends C> accessor) {
        return (C)accessor.get(tuple, 3);
    }

    public static <X, C> QuadAccessor<X, C> bind(TupleAccessor<X, C> accessor) {
        return new QuadAccessorImpl<X, C>(accessor);
    }

    public static class QuadAccessorImpl<X, C>
    implements QuadAccessor<X, C> {
        protected TupleAccessor<X, C> accessor;

        public QuadAccessorImpl(TupleAccessor<X, C> accessor) {
            this.accessor = accessor;
        }

        @Override
        public C getGraph(X tuple) {
            return TupleBridgeQuad.getGraph(tuple, this.accessor);
        }

        @Override
        public C getSubject(X tuple) {
            return TupleBridgeQuad.getSubject(tuple, this.accessor);
        }

        @Override
        public C getPredicate(X tuple) {
            return TupleBridgeQuad.getPredicate(tuple, this.accessor);
        }

        @Override
        public C getObject(X tuple) {
            return TupleBridgeQuad.getObject(tuple, this.accessor);
        }
    }
}

