/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.dataset;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.aksw.jenax.arq.util.dataset.DatasetGraphWrapperFindBase;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapperView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class DatasetGraphUnionDefaultGraph
extends DatasetGraphWrapperFindBase
implements DatasetGraphWrapperView {
    private static Set<Predicate<DatasetGraph>> knownUnionDefaultGraphCheckers;
    private static final Symbol tdbSymbol1;
    private static final Symbol tdbSymbol2;

    public DatasetGraphUnionDefaultGraph(DatasetGraph dsg) {
        super(dsg);
    }

    @Override
    protected Iterator<Quad> actionFind(boolean ng, Node g, Node s, Node p, Node o) {
        Iter result;
        if (Quad.isDefaultGraph((Node)g)) {
            result = this.findInUdf(s, p, o);
        } else {
            Iter emitUdf = Node.ANY.equals((Object)g) && !ng ? Iter.of((Object[])new Boolean[]{true, false}) : Iter.of((Object)false);
            result = emitUdf.flatMap(udf -> udf != false ? this.findInUdf(s, p, o) : this.getR().findNG(g, s, p, o));
        }
        return result;
    }

    private Iterator<Quad> findInUdf(Node s, Node p, Node o) {
        return Iter.iter((Iterator)this.getR().findNG(Quad.unionGraph, s, p, o)).map(q -> Quad.defaultGraphIRI.equals((Object)q.getGraph()) ? q : Quad.create((Node)Quad.defaultGraphIRI, (Node)q.getSubject(), (Node)q.getPredicate(), (Node)q.getObject()));
    }

    public static DatasetGraph wrap(DatasetGraph dsg) {
        Object result = dsg instanceof DatasetGraphUnionDefaultGraph ? dsg : new DatasetGraphUnionDefaultGraph(dsg);
        return result;
    }

    public static DatasetGraph wrapIfNeeded(DatasetGraph dsg) {
        DatasetGraph result = !(dsg instanceof DatasetGraphUnionDefaultGraph) && DatasetGraphUnionDefaultGraph.isKnownUnionDefaultGraphMode(dsg) ? new DatasetGraphUnionDefaultGraph(dsg) : dsg;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<Predicate<DatasetGraph>> getUnionDefaultGraphCheckers() {
        if (knownUnionDefaultGraphCheckers != null) return knownUnionDefaultGraphCheckers;
        Class<DatasetGraphUnionDefaultGraph> clazz = DatasetGraphUnionDefaultGraph.class;
        synchronized (DatasetGraphUnionDefaultGraph.class) {
            if (knownUnionDefaultGraphCheckers != null) return knownUnionDefaultGraphCheckers;
            knownUnionDefaultGraphCheckers = Collections.synchronizedSet(new LinkedHashSet());
            knownUnionDefaultGraphCheckers.add(dsg -> DatasetGraphUnionDefaultGraph.isTdbUnionDefaultGraph(dsg.getContext()));
            // ** MonitorExit[var0] (shouldn't be in output)
            return knownUnionDefaultGraphCheckers;
        }
    }

    public static boolean isTdbUnionDefaultGraph(Context cxt) {
        boolean result = cxt != null && (cxt.isTrue(tdbSymbol2) || cxt.isTrue(tdbSymbol1));
        return result;
    }

    public static boolean isKnownUnionDefaultGraphMode(DatasetGraph dsg) {
        Predicate<DatasetGraph> predicate;
        boolean result = false;
        Iterator<Predicate<DatasetGraph>> iterator = DatasetGraphUnionDefaultGraph.getUnionDefaultGraphCheckers().iterator();
        while (iterator.hasNext() && !(result = (predicate = iterator.next()).test(dsg))) {
        }
        return result;
    }

    static {
        tdbSymbol1 = Symbol.create((String)"http://jena.hpl.hp.com/TDB#unionDefaultGraph");
        tdbSymbol2 = Symbol.create((String)"http://jena.apache.org/TDB#unionDefaultGraph");
    }
}

