/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.dataset;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Quad;

public class DatasetDescriptionUtils {
    public static DatasetDescription ofStrings(Collection<String> graphIris, Collection<String> namedGraphIris) {
        return DatasetDescription.create(DatasetDescriptionUtils.asListOrCopy(graphIris), DatasetDescriptionUtils.asListOrCopy(namedGraphIris));
    }

    public static DatasetDescription ofNodes(Collection<Node> graphIris, Collection<Node> namedGraphIris) {
        return DatasetDescription.create(DatasetDescriptionUtils.asListOrCopy(graphIris).stream().map(Node::getURI).toList(), DatasetDescriptionUtils.asListOrCopy(namedGraphIris).stream().map(Node::getURI).toList());
    }

    private static <T> List<T> asListOrCopy(Collection<T> items) {
        return items == null ? List.of() : DatasetDescriptionUtils.asListOrCopyOrNull(items);
    }

    private static <T> List<T> asListOrCopyOrNull(Collection<T> items) {
        List<T> list;
        return items instanceof List ? (list = (List<T>)items) : (items == null ? null : List.copyOf(items));
    }

    public static void mergeInto(DatasetDescription target, DatasetDescription source) {
        target.addAllDefaultGraphURIs((Collection)source.getDefaultGraphURIs());
        target.addAllNamedGraphURIs((Collection)source.getNamedGraphURIs());
    }

    public static String getSingleDefaultGraphUri(DatasetDescription datasetDescription) {
        String result;
        if (datasetDescription == null) {
            result = Quad.defaultGraphIRI.getURI();
        } else {
            List dgus = datasetDescription.getDefaultGraphURIs();
            result = datasetDescription != null && dgus.size() == 1 ? (String)dgus.iterator().next() : null;
        }
        return result;
    }

    public static DatasetDescription createDefaultGraph(Node defaultGraph) {
        DatasetDescription result = DatasetDescriptionUtils.createDefaultGraph(defaultGraph.getURI());
        return result;
    }

    public static DatasetDescription createDefaultGraph(String defaultGraph) {
        DatasetDescription result = new DatasetDescription();
        result.addDefaultGraphURI(defaultGraph);
        return result;
    }

    public static String toString(DatasetDescription datasetDescription) {
        String result = datasetDescription == null ? null : "[defaultGraphs = " + Joiner.on((String)", ").join((Iterable)datasetDescription.getDefaultGraphURIs()) + "][namedGraphs = " + Joiner.on((String)", ").join((Iterable)datasetDescription.getNamedGraphURIs()) + "]";
        return result;
    }
}

