/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.prefix;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.prefix.PrefixMappingTrie;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.EltStreamRDF;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.util.PrefixMapping2;

public class PrefixUtils {
    public static void usedPrefixes(PrefixMapping in, Stream<Node> node, PrefixMapping out) {
        node.forEach(n -> PrefixUtils.usedPrefixes(n, in, out));
    }

    public static void usedPrefixes(Node node, PrefixMapping in, PrefixMapping out) {
        String iri;
        if (node.isURI()) {
            String iri2 = node.getURI();
            PrefixUtils.addPrefix(iri2, in, out);
        } else if (node.isLiteral() && (iri = node.getLiteralDatatypeURI()) != null) {
            PrefixUtils.addPrefix(iri, in, out);
        }
    }

    public static void addPrefix(String iri, PrefixMapping in, PrefixMapping out) {
        Map.Entry<String, String> e = PrefixUtils.findLongestPrefix(in, iri);
        if (e != null) {
            String prefix = e.getKey();
            String uri = e.getValue();
            out.setNsPrefix(prefix, uri);
        }
    }

    public static Map.Entry<String, String> findLongestPrefix(PrefixMapping pm, String uri) {
        Map.Entry<String, String> result;
        if (pm == null) {
            result = null;
        } else if (pm instanceof PrefixMappingTrie) {
            PrefixMappingTrie pmt = (PrefixMappingTrie)pm;
            result = pmt.findMapping(uri, true).orElse(null);
        } else if (pm instanceof PrefixMapping2) {
            PrefixMapping2 pm2 = (PrefixMapping2)pm;
            result = PrefixUtils.findLongestPrefix(pm2.getLocalPrefixMapping(), uri);
            if (result == null) {
                result = PrefixUtils.findLongestPrefix(pm2.getGlobalPrefixMapping(), uri);
            }
        } else {
            result = PrefixUtils.findLongestPrefixCore(pm, uri);
        }
        return result;
    }

    public static Map.Entry<String, String> findLongestPrefixCore(PrefixMapping pm, String uri) {
        int bestResultLength = -1;
        Map.Entry bestResult = null;
        Map nsPrefixMap = pm.getNsPrefixMap();
        for (Map.Entry e : nsPrefixMap.entrySet()) {
            String ss = (String)e.getValue();
            int l = ss.length();
            if (l <= bestResultLength || !uri.startsWith(ss) || l == uri.length()) continue;
            bestResultLength = l;
            bestResult = e;
        }
        return bestResult;
    }

    public static PrefixMapping usedPrefixes(PrefixMapping pm, Set<Node> nodes) {
        PrefixMappingImpl result = new PrefixMappingImpl();
        Stream<Node> nodeStream = nodes.stream();
        PrefixUtils.usedPrefixes(pm, nodeStream, (PrefixMapping)result);
        return result;
    }

    public static String toString(PrefixMapping prefixMapping, RDFFormat rdfFormat) {
        Model tmp = ModelFactory.createDefaultModel();
        tmp.setNsPrefixes(prefixMapping);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)baos, (Model)tmp, (RDFFormat)rdfFormat);
        String result = null;
        try {
            result = baos.toString("UTF-8").trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static PrefixMapping fromString(String str, Lang lang) {
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model, (InputStream)new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)), (Lang)lang);
        PrefixMappingImpl result = new PrefixMappingImpl();
        result.setNsPrefixes(model.getNsPrefixMap());
        return result;
    }

    public static PrefixMap readPrefixes(PrefixMap sink, InputStream in, Lang lang) {
        return PrefixUtils.readPrefixes(sink, in, lang, 1000L);
    }

    public static PrefixMap readPrefixes(PrefixMap sink, InputStream in, Lang lang, long maxNonPrefixEventCount) {
        PrefixMap dst = sink == null ? PrefixMapFactory.create() : sink;
        try (Stream stream = AsyncParser.of((InputStream)in, (Lang)lang, null).setChunkSize(100).streamElements();){
            Iterator it = stream.iterator();
            long nonPrefixEventCount = 0L;
            while (it.hasNext() && nonPrefixEventCount < maxNonPrefixEventCount) {
                EltStreamRDF event = (EltStreamRDF)it.next();
                if (event.isPrefix()) {
                    String eventPrefix = event.prefix();
                    String eventIri = event.iri();
                    String priorIri = dst.get(eventPrefix);
                    if (priorIri != null && priorIri.equals(eventIri)) {
                        ++nonPrefixEventCount;
                        continue;
                    }
                    dst.add(eventPrefix, eventIri);
                    nonPrefixEventCount = 0L;
                    continue;
                }
                ++nonPrefixEventCount;
            }
        }
        return dst;
    }
}

