/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.expr;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;

public class ExprListUtils {
    public static ExprList nodesToExprs(Iterable<Node> nodes) {
        ExprList result = new ExprList();
        for (Node node : nodes) {
            Expr e = ExprLib.nodeToExpr((Node)node);
            result.add(e);
        }
        return result;
    }

    public static Set<Set<Expr>> toSets(List<ExprList> clauses) {
        if (clauses == null) {
            return null;
        }
        LinkedHashSet<Set<Expr>> result = new LinkedHashSet<Set<Expr>>();
        for (ExprList clause : clauses) {
            result.add(new LinkedHashSet(clause.getList()));
        }
        return result;
    }

    public static boolean contains(ExprList exprList, Expr expr) {
        Expr item;
        boolean result = false;
        Iterator iterator = exprList.iterator();
        while (iterator.hasNext() && !(result = (item = (Expr)iterator.next()).equals((Object)expr))) {
        }
        return result;
    }

    public static ExprList fromUris(Iterable<String> uris) {
        List<Node> nodes = NodeUtils.fromUris(uris);
        ExprList result = ExprListUtils.nodesToExprs(nodes);
        return result;
    }
}

