/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.binding;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.util.ModelUtils;

public class QuerySolutionUtils {
    public static QuerySolution applyNodeTransformToKeys(NodeTransform nodeTransform, QuerySolution qs) {
        QuerySolutionMap result = new QuerySolutionMap();
        Iterator itVarNames = qs.varNames();
        while (itVarNames.hasNext()) {
            String varName = (String)itVarNames.next();
            RDFNode rdfNode = qs.get(varName);
            Var sourceVar = Var.alloc((String)varName);
            Var targetVar = (Var)nodeTransform.apply((Object)sourceVar);
            if (targetVar == null) {
                targetVar = sourceVar;
            }
            String targetVarName = targetVar.getVarName();
            result.add(targetVarName, rdfNode);
        }
        return result;
    }

    public static QuerySolution renameKeys(QuerySolution qs, Map<Var, Var> varMap) {
        return QuerySolutionUtils.applyNodeTransformToKeys(NodeTransformRenameMap.create(varMap), qs);
    }

    public static Function<Binding, QuerySolution> newGraphAwareBindingMapper(Dataset dataset, String nodeVarName, String graphVarName) {
        return QuerySolutionUtils.newGraphAwareBindingMapper(dataset, Collections.singletonMap(Var.alloc((String)nodeVarName), Var.alloc((String)graphVarName)));
    }

    public static Function<Binding, QuerySolution> newGraphAwareBindingMapper(Dataset dataset, Map<Var, Var> nodeVarToGraphVar) {
        return binding -> {
            QuerySolutionMap qs = new QuerySolutionMap();
            binding.vars().forEachRemaining(nodeVar -> {
                Var graphVar = (Var)nodeVarToGraphVar.get(nodeVar);
                String nodeVarName = nodeVar.getName();
                Node graphNode = graphVar == null ? Quad.defaultGraphIRI : binding.get(graphVar);
                Graph graph = dataset.asDatasetGraph().getGraph(graphNode);
                Model model = ModelFactory.createModelForGraph((Graph)graph);
                RDFNode rdfNode = ModelUtils.convertGraphNodeToRDFNode((Node)graphNode, (Model)model);
                qs.add(nodeVarName, rdfNode);
            });
            return qs;
        };
    }
}

