/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.binding;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;

public class BindingRemapped
implements Binding {
    protected Binding delegate;
    protected Map<Var, Var> varMap;
    protected transient Set<Var> effectiveKeys;

    protected BindingRemapped(Binding delegate, Map<Var, Var> varMap) {
        this.delegate = Objects.requireNonNull(delegate);
        this.varMap = Objects.requireNonNull(varMap);
    }

    public static Binding of(Binding delegate, Map<Var, Var> varMap) {
        return new BindingRemapped(delegate, varMap);
    }

    protected Set<Var> effectiveKeys() {
        if (this.effectiveKeys == null) {
            this.effectiveKeys = this.varMap.keySet().stream().filter(arg_0 -> ((Binding)this.delegate).contains(arg_0)).collect(Collectors.toSet());
        }
        return this.effectiveKeys;
    }

    public Iterator<Var> vars() {
        return this.varMap.keySet().stream().filter(arg_0 -> ((Binding)this.delegate).contains(arg_0)).iterator();
    }

    public Set<Var> varsMentioned() {
        return this.effectiveKeys();
    }

    public void forEach(BiConsumer<Var, Node> action) {
        this.varMap.forEach((? super K v, ? super V w) -> {
            if (this.delegate.contains(w)) {
                action.accept((Var)v, this.delegate.get(w));
            }
        });
    }

    public boolean contains(Var var) {
        Var v = this.varMap.get(var);
        return this.delegate.contains(v);
    }

    public Node get(Var var) {
        Var v = this.varMap.get(var);
        Node result = v == null ? null : this.delegate.get(v);
        return result;
    }

    public int size() {
        return (int)this.varMap.keySet().stream().filter(arg_0 -> ((Binding)this.delegate).contains(arg_0)).count();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.delegate.toString() + ": " + String.valueOf(this.varMap);
    }

    public Binding detach() {
        Binding d = this.delegate == null ? null : this.delegate.detach();
        return d == this.delegate ? this : new BindingRemapped(d, this.varMap);
    }
}

