/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.triple;

import org.aksw.jenax.arq.util.triple.TripleConstraint;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;

public class TripleConstraintImpl
implements TripleConstraint {
    protected Triple pattern;
    protected Expr expr;

    public TripleConstraintImpl(Triple pattern, Expr expr) {
        this.pattern = pattern;
        this.expr = expr;
    }

    public static TripleConstraint create(Expr expr) {
        return TripleConstraintImpl.create(Triple.createMatch(null, null, null), expr);
    }

    public static TripleConstraint create(Node s, Node p, Node o) {
        return TripleConstraintImpl.create(Triple.createMatch((Node)s, (Node)p, (Node)o));
    }

    public static TripleConstraint create(Triple pattern) {
        return TripleConstraintImpl.create(pattern, null);
    }

    public static TripleConstraint create(Triple triple, Expr expr) {
        return new TripleConstraintImpl(triple, expr);
    }

    @Override
    public boolean test(Triple t) {
        boolean result;
        Binding b = TripleUtils.tripleToBinding(this.pattern, t);
        if (b == null) {
            result = false;
        } else if (this.expr == null) {
            result = true;
        } else {
            NodeValue nv = ExprUtils.eval((Expr)this.expr, (Binding)b);
            result = nv.getBoolean();
        }
        return result;
    }

    @Override
    public Triple getMatchTriple() {
        return this.pattern;
    }

    @Override
    public boolean isMatchTripleExhaustive() {
        return this.expr == null;
    }

    @Override
    public Expr getExpr() {
        return this.expr;
    }
}

