/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.exec.query;

import com.google.common.collect.BiMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.dataset.DynamicDatasetUtils;
import org.aksw.jenax.arq.util.node.VarScopeUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.optimize.Optimize;
import org.apache.jena.sparql.algebra.optimize.RewriteFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterCommonParent;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIteratorMapped;
import org.apache.jena.sparql.util.Context;

public class QueryExecUtils {
    public static <T> QueryIterator fromStream(Stream<T> stream, Var outVar, Binding parentBinding, ExecutionContext execCxt, Function<? super T, ? extends Node> toNode) {
        QueryIterator result = QueryIterPlainWrapper.create((Iterator)Iter.onClose(stream.map(toNode).map(n -> BindingFactory.binding((Binding)parentBinding, (Var)outVar, (Node)n)).iterator(), stream::close), (ExecutionContext)execCxt);
        return result;
    }

    public static QueryIterator fromStream(Stream<Binding> stream, ExecutionContext execCxt) {
        QueryIterator result = QueryIterPlainWrapper.create((Iterator)Iter.onClose(stream.iterator(), stream::close), (ExecutionContext)execCxt);
        return result;
    }

    public static QueryIterator execute(Op op, DatasetGraph dataset, Binding binding, Context cxt) {
        QueryIterator innerIter = null;
        QueryIterator outerIter = null;
        ExecutionContext execCxt = null;
        DynamicDatasets.DynamicDatasetGraph ddg = DynamicDatasetUtils.asUnwrappableDynamicDatasetOrNull(dataset);
        if (ddg != null) {
            Set visibleVars = OpVars.visibleVars((Op)op);
            BiMap normedToScoped = VarScopeUtils.normalizeVarScopes(visibleVars).inverse();
            Op opRestored = Rename.reverseVarRename((Op)op, (boolean)true);
            Query baseQuery = OpAsQuery.asQuery((Op)opRestored);
            Pair<Query, DatasetGraph> pair = DynamicDatasetUtils.unwrap(baseQuery, (DatasetGraph)ddg);
            Query effQuery = (Query)pair.getLeft();
            DatasetGraph effDataset = (DatasetGraph)pair.getRight();
            QueryEngineFactory qef = QueryEngineRegistry.findFactory((Query)effQuery, (DatasetGraph)effDataset, (Context)cxt);
            Plan plan = qef.create(effQuery, effDataset, BindingFactory.empty(), cxt);
            innerIter = plan.iterator();
            outerIter = new QueryIteratorMapped(innerIter, (Map)normedToScoped);
        }
        if (innerIter == null) {
            QueryEngineFactory qef = QueryEngineRegistry.findFactory((Op)op, (DatasetGraph)dataset, (Context)cxt);
            Plan plan = qef.create(op, dataset, BindingFactory.empty(), cxt);
            outerIter = innerIter = plan.iterator();
        }
        execCxt = innerIter instanceof QueryIter ? ((QueryIter)innerIter).getExecContext() : null;
        QueryIterCommonParent result = new QueryIterCommonParent(outerIter, binding, execCxt);
        return result;
    }

    public static Map<Var, Var> computeVarMapping(Op opRemote, Op opRestored) {
        boolean requiresRemapping = false;
        HashMap<Var, Var> varMapping = null;
        if (!opRestored.equals(opRemote)) {
            varMapping = new HashMap<Var, Var>();
            Set originalVars = OpVars.visibleVars((Op)opRemote);
            Set remoteVars = OpVars.visibleVars((Op)opRestored);
            for (Var v : originalVars) {
                if (v.getName().contains("/")) {
                    String origName = v.getName().substring(v.getName().lastIndexOf(47) + 1);
                    Var remoteVar = Var.alloc((String)origName);
                    if (!remoteVars.contains(remoteVar)) continue;
                    varMapping.put(remoteVar, v);
                    requiresRemapping = true;
                    continue;
                }
                if (!remoteVars.contains(v)) continue;
                varMapping.put(v, v);
            }
        }
        HashMap<Var, Var> result = requiresRemapping ? varMapping : null;
        return result;
    }

    public static RewriteFactory decideOptimizer(Context context) {
        RewriteFactory result = (RewriteFactory)context.get(ARQConstants.sysOptimizerFactory);
        if (result == null && (result = Optimize.getFactory()) == null) {
            result = Optimize.stdOptimizationFactory;
        }
        return result;
    }
}

