/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.update;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jenax.arq.util.node.NodeTransformCollectNodes;
import org.aksw.jenax.arq.util.prefix.PrefixUtils;
import org.aksw.jenax.arq.util.prologue.PrologueUtils;
import org.aksw.jenax.arq.util.quad.SetFromDatasetGraph;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.triple.SetFromGraph;
import org.aksw.jenax.arq.util.update.UpdateTransform;
import org.aksw.jenax.arq.util.update.UpdateUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.modify.request.QuadDataAcc;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteInsert;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.util.PrefixMapping2;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class UpdateRequestUtils {
    public static UpdateRequest optimizePrefixes(UpdateRequest updateRequest) {
        UpdateRequestUtils.optimizePrefixes(updateRequest, null);
        return updateRequest;
    }

    public static UpdateRequest optimizePrefixes(UpdateRequest updateRequest, PrefixMapping globalPm) {
        PrefixMapping usedPrefixes = UpdateRequestUtils.usedPrefixes(updateRequest, globalPm);
        updateRequest.setPrefixMapping(usedPrefixes);
        return updateRequest;
    }

    public static PrefixMapping usedPrefixes(UpdateRequest updateRequest, PrefixMapping global) {
        PrefixMapping local = updateRequest.getPrefixMapping();
        PrefixMapping pm = global == null ? local : new PrefixMapping2(global, local);
        PrefixMapping result = UpdateRequestUtils.usedReferencePrefixes(updateRequest, pm);
        return result;
    }

    public static PrefixMapping usedReferencePrefixes(UpdateRequest updateRequest, PrefixMapping pm) {
        NodeTransformCollectNodes nodeUsageCollector = new NodeTransformCollectNodes();
        UpdateRequestUtils.applyNodeTransform(updateRequest, nodeUsageCollector);
        Set<Node> nodes = nodeUsageCollector.getNodes();
        PrefixMapping result = PrefixUtils.usedPrefixes(pm, nodes);
        return result;
    }

    public static UpdateRequest applyNodeTransform(UpdateRequest updateRequest, NodeTransform nodeTransform) {
        UpdateRequest result = UpdateRequestUtils.copyTransform(updateRequest, update -> {
            Update r = UpdateUtils.applyNodeTransform(update, nodeTransform);
            return r;
        });
        return result;
    }

    public static UpdateRequest applyTransformElt(UpdateRequest updateRequest, Function<? super Element, ? extends Element> transform) {
        UpdateRequest result = UpdateRequestUtils.copyTransform(updateRequest, update -> {
            Update r = UpdateUtils.applyElementTransform(update, transform);
            return r;
        });
        return result;
    }

    public static UpdateRequest applyOpTransform(UpdateRequest updateRequest, Function<? super Op, ? extends Op> transform) {
        UpdateRequest result = UpdateRequestUtils.copyTransform(updateRequest, update -> {
            Update r = UpdateUtils.applyOpTransform(update, transform);
            return r;
        });
        return result;
    }

    public static UpdateRequest append(UpdateRequest tgt, UpdateRequest src) {
        src.getOperations().forEach(arg_0 -> ((UpdateRequest)tgt).add(arg_0));
        return tgt;
    }

    public static UpdateRequest clone(UpdateRequest request) {
        UpdateRequest result = UpdateRequestUtils.copyTransform(request, UpdateUtils::clone);
        return result;
    }

    public static UpdateRequest copyTransform(UpdateRequest request, UpdateTransform updateTransform) {
        UpdateRequest result = new UpdateRequest();
        PrologueUtils.copy((Prologue)result, (Prologue)request);
        for (Update update : request.getOperations()) {
            Update newUpdate = (Update)updateTransform.apply(update);
            if (newUpdate == null) continue;
            result.add(newUpdate);
        }
        return result;
    }

    public static UpdateRequest copyWithIri(UpdateRequest updateRequest, String withIri, boolean substituteDefaultGraph) {
        UpdateRequest result = UpdateRequestUtils.copyTransform(updateRequest, update -> UpdateUtils.copyWithIri(update, withIri, substituteDefaultGraph));
        return result;
    }

    public static UpdateRequest copyWithIri(UpdateRequest updateRequest, Node withIri, boolean substituteDefaultGraph) {
        UpdateRequest result = UpdateRequestUtils.copyTransform(updateRequest, update -> UpdateUtils.copyWithIri(update, withIri, substituteDefaultGraph));
        return result;
    }

    public static void applyWithIri(UpdateRequest updateRequest, String withIri) {
        for (Update update : updateRequest.getOperations()) {
            UpdateUtils.applyWithIriIfApplicable(update, withIri);
        }
    }

    public static void applyDatasetDescription(UpdateRequest updateRequest, DatasetDescription dg) {
        for (Update update : updateRequest.getOperations()) {
            UpdateUtils.applyDatasetDescriptionIfApplicable(update, dg);
        }
    }

    public static void overwriteDatasetDescription(UpdateRequest updateRequest, DatasetDescription dg) {
        for (Update update : updateRequest.getOperations()) {
            UpdateUtils.overwriteDatasetDescriptionIfApplicable(update, dg);
        }
    }

    public static void fixVarNames(UpdateRequest updateRequest) {
        List updates = updateRequest.getOperations();
        for (Update update : updates) {
            Element after;
            Element before;
            UpdateDeleteInsert x;
            if (update instanceof UpdateDeleteInsert) {
                x = (UpdateDeleteInsert)update;
                before = x.getWherePattern();
                after = ElementUtils.fixVarNames(before);
                x.setElement(after);
                continue;
            }
            if (!(update instanceof UpdateModify)) continue;
            x = (UpdateModify)update;
            before = x.getWherePattern();
            after = ElementUtils.fixVarNames(before);
            x.setElement(after);
        }
    }

    public static UpdateRequest createUpdateRequestDatasetGraph(Diff<? extends DatasetGraph> diff) {
        Iterator a = ((DatasetGraph)diff.getAdded()).find();
        Iterator b = ((DatasetGraph)diff.getRemoved()).find();
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest(a, b);
        return result;
    }

    public static UpdateRequest createUpdateRequest(Diff<? extends Iterable<? extends Quad>> diff) {
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest((Iterable)diff.getAdded(), (Iterable)diff.getRemoved());
        return result;
    }

    public static UpdateRequest createUpdateRequest(Model added, Model removed) {
        SetFromGraph _a = added == null ? Collections.emptySet() : SetFromGraph.wrap(added.getGraph());
        SetFromGraph _r = removed == null ? Collections.emptySet() : SetFromGraph.wrap(removed.getGraph());
        Iterable a = Iterables.transform((Iterable)_a, t -> new Quad(Quad.defaultGraphIRI, t));
        Iterable r = Iterables.transform((Iterable)_r, t -> new Quad(Quad.defaultGraphIRI, t));
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest(a, r);
        return result;
    }

    public static UpdateRequest createUpdateRequest(Dataset added, Dataset removed) {
        SetFromDatasetGraph a = added == null ? Collections.emptySet() : SetFromDatasetGraph.wrap(added.asDatasetGraph());
        SetFromDatasetGraph r = removed == null ? Collections.emptySet() : SetFromDatasetGraph.wrap(removed.asDatasetGraph());
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest(a, r);
        return result;
    }

    public static UpdateRequest createUpdateRequest(Iterable<? extends Quad> added, Iterable<? extends Quad> removed) {
        Iterator<? extends Quad> a = added == null ? null : added.iterator();
        Iterator<? extends Quad> b = removed == null ? null : removed.iterator();
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest(a, b);
        return result;
    }

    public static UpdateRequest createUpdateRequest(Iterator<? extends Quad> added, Iterator<? extends Quad> removed) {
        UpdateRequest result = new UpdateRequest();
        if (added != null && added.hasNext()) {
            QuadDataAcc insertQuads = new QuadDataAcc((List)Lists.newArrayList(added));
            UpdateDataInsert insertData = new UpdateDataInsert(insertQuads);
            result.add((Update)insertData);
        }
        if (removed != null && removed.hasNext()) {
            QuadDataAcc deleteQuads = new QuadDataAcc((List)Lists.newArrayList(removed));
            UpdateDataDelete deleteData = new UpdateDataDelete(deleteQuads);
            result.add((Update)deleteData);
        }
        return result;
    }

    public static UpdateRequest parse(String requestStr) {
        UpdateRequest result = new UpdateRequest();
        UpdateFactory.parse((UpdateRequest)result, (String)requestStr);
        return result;
    }
}

