/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.commons.tuple.bridge.TupleBridge3;
import org.aksw.commons.tuple.finder.TupleFinder3;
import org.aksw.commons.tuple.finder.TupleFinder3Wrapper;
import org.aksw.commons.util.cache.CacheUtils;
import org.aksw.jenax.arq.util.tuple.IterUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple2;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfs.engine.CxtInf;
import org.apache.jena.rdfs.engine.MapperX;
import org.apache.jena.rdfs.engine.MatchRDFS;
import org.apache.jena.rdfs.setup.ConfigRDFS;

public class MatchRDFSReduced<D, C>
extends TupleFinder3Wrapper<D, C, TupleFinder3<D, C>> {
    protected CxtInf<C, D> cxtInf;
    protected TupleFinder3<D, C> backend;
    boolean alwaysFetchRangeTypesBySubject = false;
    float enumerationThresholdFactor = 30.0f;

    protected MatchRDFSReduced(TupleFinder3<D, C> matchRDFS, TupleFinder3<D, C> backend, CxtInf<C, D> cxtInf) {
        super(matchRDFS);
        this.cxtInf = cxtInf;
        this.backend = backend;
    }

    public static <D, C> TupleFinder3<D, C> create(ConfigRDFS<C> setup, MapperX<C, D> mapper, TupleFinder3<D, C> backend) {
        InfFindTuple<D, C> matchRDFS = new InfFindTuple<D, C>(setup, mapper, backend);
        return new MatchRDFSReduced<D, C>(matchRDFS, backend, matchRDFS);
    }

    protected boolean isTerm(C c) {
        return !this.isAny(c);
    }

    protected boolean isAny(C c) {
        return c == null || this.cxtInf.ANY.equals(c);
    }

    public Stream<D> find(C s, C p, C o) {
        Stream<Object> result;
        boolean isRdfType = this.cxtInf.rdfType.equals(p);
        if (this.cxtInf.setup.hasRDFS() && (this.isAny(p) || isRdfType) && this.isAny(o)) {
            Worker_S_ANY_ANY worker = new Worker_S_ANY_ANY(s);
            result = worker.find();
            if (isRdfType) {
                result = result.filter(t -> this.cxtInf.rdfType.equals(this.getTupleBridge().get(t, 1)));
            }
        } else {
            result = ((TupleFinder3)this.base).find(s, p, o);
        }
        return result;
    }

    public static <T> Set<T> addAndGetNew(Set<T> acc, Set<T> base, T addition) {
        return MatchRDFSReduced.addAndGetNew(acc, base, Collections.singleton(addition));
    }

    public static <T> Set<T> addAndGetNew(Set<T> acc, Set<T> base, Set<T> additions) {
        Set<T> result = acc;
        ArrayList newItems = new ArrayList(Sets.difference(additions, base));
        base.addAll(newItems);
        if (!newItems.isEmpty()) {
            if (result == null) {
                result = new LinkedHashSet<T>();
            }
            result.addAll(newItems);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <D, C> Set<C> getPredicates(TupleFinder3<D, C> backend, C s, boolean isForward, C any, long enumerationThreshold, Set<C> enumeration) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        boolean seenAll = false;
        int maxSeeableSize = enumeration.size();
        if (enumerationThreshold > 0L) {
            Iterator it = (isForward ? backend.find(s, any, any) : backend.find(any, any, s)).map(tuple -> backend.getTupleBridge().get(tuple, 1)).iterator();
            long counter = 0L;
            try {
                boolean aborted = false;
                while (it.hasNext()) {
                    Object p = it.next();
                    result.add(p);
                    if (++counter > enumerationThreshold) {
                        aborted = true;
                        break;
                    }
                    if (result.size() < maxSeeableSize) continue;
                    seenAll = true;
                    break;
                }
                seenAll = !aborted;
            }
            finally {
                Iter.close(it);
            }
        }
        if (!seenAll) {
            HashSet remainingCands = new HashSet(Sets.difference(enumeration, result));
            for (Object candP : remainingCands) {
                boolean isPresent = isForward ? backend.contains(s, candP, any) : backend.contains(any, candP, s);
                if (!isPresent) continue;
                result.add(candP);
            }
        }
        return result;
    }

    public static class InfFindTuple<D, C>
    extends MatchRDFS<C, D>
    implements TupleFinder3<D, C> {
        private final TupleFinder3<D, C> base;

        public InfFindTuple(ConfigRDFS<C> setup, MapperX<C, D> mapper, TupleFinder3<D, C> backend) {
            super(setup, mapper);
            this.base = backend;
        }

        public Stream<D> sourceFind(C s, C p, C o) {
            return this.base.find(s, p, o);
        }

        protected boolean sourceContains(C s, C p, C o) {
            return this.base.contains(s, p, o);
        }

        protected D dstCreate(C s, C p, C o) {
            return (D)this.base.getTupleBridge().build(s, p, o);
        }

        public Stream<D> find(C s, C p, C o) {
            return this.match(s, p, o);
        }

        public TupleBridge3<D, C> getTupleBridge() {
            return this.base.getTupleBridge();
        }
    }

    public class Worker_S_ANY_ANY {
        protected ConfigRDFS<C> setup;
        protected C ms;
        protected C mp;
        protected C mo;
        protected Cache<C, Set<C>> seenTypesCache;
        protected Cache<C, Set<C>> seenOutPredicatesCache;
        protected Cache<Tuple2<C>, Set<C>> seenLinksCache;
        protected Set<C> inPredicateCands;
        public long enumerationThreshold;

        public Worker_S_ANY_ANY(C ms) {
            this.setup = MatchRDFSReduced.this.cxtInf.setup;
            this.seenTypesCache = CacheBuilder.newBuilder().maximumSize(10000L).build();
            this.seenOutPredicatesCache = CacheBuilder.newBuilder().maximumSize(10000L).build();
            this.seenLinksCache = CacheBuilder.newBuilder().maximumSize(100000L).build();
            this.ms = ms;
            this.inPredicateCands = this.setup.getPropertyRanges().keySet();
            this.enumerationThreshold = (long)((float)this.inPredicateCands.size() * MatchRDFSReduced.this.enumerationThresholdFactor);
        }

        public Stream<D> find() {
            return Iter.asStream((Iterator)IterUtils.iter(MatchRDFSReduced.this.backend.find(this.ms, this.mp, this.mo)).flatMap(this::inf));
        }

        protected D tuple(C s, C p, C o) {
            return MatchRDFSReduced.this.getTupleBridge().build(s, p, o);
        }

        protected Iterator<D> inf(D tuple) {
            Object result;
            boolean isSuppressedTriple;
            Set<Object> superPropertiesInc;
            boolean isNewOutPredicate;
            Object s = MatchRDFSReduced.this.getTupleBridge().get(tuple, 0);
            Object p = MatchRDFSReduced.this.getTupleBridge().get(tuple, 1);
            Object o = MatchRDFSReduced.this.getTupleBridge().get(tuple, 2);
            boolean hasSeenSubject = CacheUtils.getIfPresent(this.seenTypesCache, (Object)s) != null;
            Set seenTypes = (Set)CacheUtils.get(this.seenTypesCache, (Object)s, () -> new HashSet());
            Set seenOutPredicates = (Set)CacheUtils.get(this.seenOutPredicatesCache, (Object)s, () -> new HashSet());
            boolean bl = isNewOutPredicate = !seenOutPredicates.contains(p);
            if (isNewOutPredicate) {
                seenOutPredicates.add(p);
            }
            Set newInfTypes = null;
            Iterator inferences = null;
            if (this.setup.hasPropertyDeclarations()) {
                superPropertiesInc = this.setup.getSuperPropertiesInc(p);
                if (superPropertiesInc.isEmpty()) {
                    superPropertiesInc = Collections.singleton(p);
                }
                inferences = this.withSuperProperties(inferences, superPropertiesInc, s, p, o);
            } else {
                superPropertiesInc = Collections.singleton(p);
            }
            if (this.setup.hasRangeDeclarations()) {
                if (!hasSeenSubject && (MatchRDFSReduced.this.alwaysFetchRangeTypesBySubject || MatchRDFSReduced.this.isTerm(this.ms))) {
                    newInfTypes = this.accRangeTypesForSubject(newInfTypes, s, seenTypes);
                }
                inferences = this.withRangeTypesForObject(inferences, s, p, o);
            }
            if (this.setup.hasClassDeclarations() && superPropertiesInc.contains(MatchRDFSReduced.this.cxtInf.rdfType) && !seenTypes.contains(o)) {
                newInfTypes = this.accTypes(newInfTypes, o, seenTypes);
            }
            if (this.setup.hasDomainDeclarations()) {
                Set domainTypes = this.setup.getDomain(p);
                newInfTypes = this.accTypes(newInfTypes, domainTypes, seenTypes);
            }
            inferences = this.withTypeInfs(inferences, s, newInfTypes);
            boolean bl2 = isSuppressedTriple = MatchRDFSReduced.this.cxtInf.rdfType.equals(p) && seenTypes.contains(o);
            if (isSuppressedTriple) {
                result = inferences == null ? Iter.empty() : inferences;
            } else {
                Iter self = Iter.of(tuple);
                result = inferences == null ? self : Iter.concat((Iterator)self, inferences);
            }
            return result;
        }

        protected Iterator<D> withTypeInfs(Iterator<D> result, C s, Set<C> newTypes) {
            if (newTypes != null) {
                result = IterUtils.getOrConcat(result, Iter.iter(newTypes).map(t -> this.tuple(s, MatchRDFSReduced.this.cxtInf.rdfType, t)));
            }
            return result;
        }

        public Iterator<D> withSuperProperties(Iterator<D> inferences, Set<C> superPropertiesInc, C s, C p, C o) {
            Set seenLinks;
            if (!(superPropertiesInc.size() == 1 && superPropertiesInc.contains(p) || (seenLinks = (Set)CacheUtils.get(this.seenLinksCache, (Object)TupleFactory.create2(s, o), HashSet::new)).contains(p))) {
                seenLinks.add(p);
                Set newlyInferredPreds = MatchRDFSReduced.addAndGetNew(null, seenLinks, superPropertiesInc);
                if (newlyInferredPreds != null) {
                    inferences = IterUtils.getOrConcat(inferences, Iter.iter(newlyInferredPreds).map(p2 -> this.tuple(s, p2, o)));
                }
            }
            return inferences;
        }

        public Iterator<D> withRangeTypesForObject(Iterator<D> inferences, C s, C p, C o) {
            Node oNode;
            if ((MatchRDFSReduced.this.isAny(this.ms) || Objects.equals(o, s) && !MatchRDFSReduced.this.alwaysFetchRangeTypesBySubject) && !(oNode = MatchRDFSReduced.this.cxtInf.mapper.toNode(o)).isLiteral()) {
                Set rangeTypes;
                boolean emitObjectRangeTypesNow = true;
                if (MatchRDFSReduced.this.alwaysFetchRangeTypesBySubject) {
                    boolean appearsAsSubject = MatchRDFSReduced.this.backend.contains(o, MatchRDFSReduced.this.cxtInf.ANY, MatchRDFSReduced.this.cxtInf.ANY);
                    boolean bl = emitObjectRangeTypesNow = !appearsAsSubject;
                }
                if (emitObjectRangeTypesNow && !(rangeTypes = this.setup.getRange(p)).isEmpty()) {
                    Set seenObjectTypes = (Set)CacheUtils.get(this.seenTypesCache, o, HashSet::new);
                    Set newlyInferredObjectTypes = this.accTypes((Set)null, rangeTypes, (Set)seenObjectTypes);
                    inferences = this.withTypeInfs(inferences, o, newlyInferredObjectTypes);
                }
            }
            return inferences;
        }

        public Set<C> accRangeTypesForSubject(Set<C> newInfTypes, C s, Set<C> seenTypes) {
            Set seenInPredicates = this.getInPredicates(s);
            for (Object inP : seenInPredicates) {
                Set rangeTypes = this.setup.getRange(inP);
                newInfTypes = this.accTypes(newInfTypes, rangeTypes, seenTypes);
            }
            return newInfTypes;
        }

        protected Set<C> accTypes(Set<C> result, C directType, Set<C> seenTypes) {
            return this.accTypes(result, Collections.singleton(directType), seenTypes);
        }

        protected Set<C> accTypes(Set<C> result, Set<C> directTypes, Set<C> seenTypes) {
            for (Object directType : directTypes) {
                if (seenTypes.contains(directType)) continue;
                result = MatchRDFSReduced.addAndGetNew(result, seenTypes, directType);
                Set typeClosure = this.setup.getSuperClasses(directType);
                result = MatchRDFSReduced.addAndGetNew(result, seenTypes, typeClosure);
            }
            return result;
        }

        protected Set<C> getInPredicates(C s) {
            Set<Object> result = MatchRDFSReduced.this.backend.contains(MatchRDFSReduced.this.cxtInf.ANY, MatchRDFSReduced.this.cxtInf.rdfType, s) ? Collections.emptySet() : MatchRDFSReduced.getPredicates(MatchRDFSReduced.this.backend, s, false, MatchRDFSReduced.this.cxtInf.ANY, this.enumerationThreshold, this.inPredicateCands);
            return result;
        }
    }

    public class Worker_ANY_ANY_O {
        public Iterator<D> find() {
            return null;
        }
    }
}

