/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.lang;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReaderRegistry;
import org.apache.jena.riot.resultset.ResultSetWriterRegistry;
import org.apache.jena.sys.JenaSystem;

public class RDFLanguagesEx {
    private static Map<Lang, Lang> subLangMap = new HashMap<Lang, Lang>();

    public static Map<Lang, Lang> getSubLangMap() {
        return subLangMap;
    }

    public static Stream<Lang> streamSubLangs(Lang lang) {
        Map<Lang, Lang> subLangMap = RDFLanguagesEx.getSubLangMap();
        Multimap mm = Multimaps.invertFrom((Multimap)Multimaps.forMap(subLangMap), (Multimap)ArrayListMultimap.create());
        Iterable it = Traverser.forTree(arg_0 -> ((Multimap)mm).get(arg_0)).breadthFirst((Object)lang);
        return Streams.stream((Iterable)it);
    }

    public static Set<Lang> expandWithSubLangs(Iterable<Lang> langs) {
        Set result = Streams.stream(langs).flatMap(l -> Stream.concat(Stream.of(l), RDFLanguagesEx.streamSubLangs(l))).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    public static List<Lang> getQuadAndTripleLangs() {
        List<Lang> result = Stream.concat(RDFLanguagesEx.getQuadLangs().stream(), RDFLanguagesEx.getTripleLangs().stream()).distinct().collect(Collectors.toList());
        return result;
    }

    public static List<Lang> getResultSetProbeLangs() {
        List<Lang> result = RDFLanguagesEx.getResultSetLangs();
        result.remove(ResultSetLang.RS_CSV);
        return result;
    }

    public static List<Lang> getResultSetLangs() {
        List<Lang> result = RDFLanguages.getRegisteredLanguages().stream().filter(ResultSetReaderRegistry::isRegistered).collect(Collectors.toList());
        return result;
    }

    public static List<Lang> getResultSetFormats() {
        List<Lang> result = RDFLanguages.getRegisteredLanguages().stream().filter(ResultSetWriterRegistry::isRegistered).collect(Collectors.toList());
        return result;
    }

    public static List<Lang> getTripleLangs() {
        List<Lang> result = RDFLanguages.getRegisteredLanguages().stream().filter(RDFLanguages::isTriples).collect(Collectors.toList());
        return result;
    }

    public static List<Lang> getQuadLangs() {
        List<Lang> result = RDFLanguages.getRegisteredLanguages().stream().filter(RDFLanguages::isQuads).collect(Collectors.toList());
        return result;
    }

    public static Set<String> getAllLangNames(Lang lang) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(lang.getName());
        result.addAll(lang.getAltNames());
        return result;
    }

    public static Set<String> getAllContentTypes(Lang lang) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ContentType primaryCt = lang.getContentType();
        if (primaryCt != null) {
            result.add(primaryCt.getContentTypeStr());
        }
        lang.getAltContentTypes().stream().filter(Objects::nonNull).forEach(result::add);
        return result;
    }

    public static List<String> getPrimaryContentTypes(Iterable<Lang> langs) {
        ArrayList<String> cts = new ArrayList<String>();
        for (Lang l : langs) {
            ContentType contentType = l.getContentType();
            if (contentType == null) continue;
            cts.add(contentType.getContentTypeStr());
        }
        return cts;
    }

    public static Set<String> getAllContentTypes(Iterable<Lang> langs) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Lang l : langs) {
            result.addAll(RDFLanguagesEx.getAllContentTypes(l));
        }
        return result;
    }

    public static boolean matchesLang(Lang lang, String label) {
        return RDFLanguagesEx.getAllLangNames(lang).stream().anyMatch(name -> name.equalsIgnoreCase(label));
    }

    public static boolean matchesFileExtension(Lang lang, String label) {
        return lang.getFileExtensions().stream().anyMatch(name -> name.equalsIgnoreCase(label));
    }

    public static boolean matchesContentType(Lang lang, String label) {
        return RDFLanguagesEx.getAllContentTypes(lang).stream().anyMatch(contentType -> contentType.equalsIgnoreCase(label));
    }

    public static RDFFormat findRdfFormat(String label) {
        RDFFormat outFormat = RDFLanguagesEx.findRdfFormat(label, RDFWriterRegistry.registeredFormats());
        return outFormat;
    }

    public static RDFFormat findRdfFormat(String label, Collection<RDFFormat> probeFormats) {
        RDFFormat outFormat = probeFormats.stream().filter(fmt -> fmt.toString().equalsIgnoreCase(label) || RDFLanguagesEx.matchesLang(fmt.getLang(), label) || RDFLanguagesEx.matchesContentType(fmt.getLang(), label)).findFirst().orElseThrow(() -> new RuntimeException("No RDF format found for label " + label));
        return outFormat;
    }

    public static Lang findLang(String label) {
        Lang result = RDFLanguagesEx.findLang(label, RDFLanguages.getRegisteredLanguages());
        return result;
    }

    public static Lang findLang(String label, Collection<Lang> probeLangs) {
        Lang result = probeLangs.stream().filter(lang -> RDFLanguagesEx.matchesLang(lang, label) || RDFLanguagesEx.matchesFileExtension(lang, label) || RDFLanguagesEx.matchesContentType(lang, label)).findFirst().orElseThrow(() -> new RuntimeException("No lang found for label " + label));
        return result;
    }

    public static Lang findLangMatchingAcceptList(AcceptList acceptableContentTypes, List<Lang> resultSetFormats, Lang fallback) {
        MediaType rsMatch = AcceptList.match((AcceptList)acceptableContentTypes, (AcceptList)AcceptList.create((String[])((String[])RDFLanguagesEx.getPrimaryContentTypes(resultSetFormats).toArray(String[]::new))));
        if (rsMatch == null) {
            rsMatch = AcceptList.match((AcceptList)acceptableContentTypes, (AcceptList)AcceptList.create((String[])((String[])RDFLanguagesEx.getAllContentTypes(resultSetFormats).toArray(String[]::new))));
        }
        if (rsMatch != null) {
            MediaType finalRsMatch = rsMatch;
            return Iter.findFirst(resultSetFormats.iterator(), p -> RDFLanguagesEx.matchesContentType(p, finalRsMatch.getContentTypeStr())).orElse(fallback);
        }
        return fallback;
    }

    public static Collection<String> listOutFormats() {
        LinkedList<String> list = new LinkedList<String>();
        RDFLanguages.getRegisteredLanguages().stream().sorted(Comparator.comparing(Lang::getName)).forEach(l -> list.add(RDFLanguagesEx.listOutFormatsAddCts(l.getName(), l)));
        RDFWriterRegistry.registeredFormats().stream().sorted(Comparator.comparing(RDFFormat::toString)).forEach(f -> list.add(RDFLanguagesEx.listOutFormatsAddCts(f.toString(), f.getLang())));
        return list;
    }

    private static String listOutFormatsAddCts(String mainName, Lang l) {
        StringBuilder s = new StringBuilder();
        s.append(mainName);
        if (l != null) {
            ContentType primaryCt = l.getContentType();
            LinkedList<String> cts = new LinkedList<String>();
            LinkedList<String> names = new LinkedList<String>();
            String name = l.getName();
            if (!name.equalsIgnoreCase(mainName)) {
                names.add(name);
            }
            l.getAltNames().stream().filter(Objects::nonNull).filter(Predicate.not(mainName::equalsIgnoreCase)).filter(e -> names.stream().noneMatch(e::equalsIgnoreCase)).forEach(names::add);
            if (primaryCt != null) {
                cts.add(primaryCt.getContentTypeStr());
            }
            l.getAltContentTypes().stream().filter(Objects::nonNull).filter(Predicate.not(cts::contains)).forEach(cts::add);
            if (!names.isEmpty() || !cts.isEmpty()) {
                s.append('\t');
                s.append(String.join((CharSequence)",", names));
            }
            if (!cts.isEmpty()) {
                s.append('\t');
                s.append(String.join((CharSequence)",", cts));
            }
        }
        return s.toString();
    }

    static {
        JenaSystem.init();
        subLangMap.put(Lang.NTRIPLES, Lang.TURTLE);
        subLangMap.put(Lang.TURTLE, Lang.TRIG);
        subLangMap.put(Lang.NQUADS, Lang.TRIG);
    }
}

