/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.dataset;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiPredicate;
import org.aksw.jenax.arq.dataset.cache.CachePatterns;
import org.aksw.jenax.arq.dataset.cache.DatasetGraphCache;
import org.aksw.jenax.arq.util.tuple.adapter.DatasetGraphOverTupleFinder;
import org.aksw.jenax.arq.util.tuple.adapter.SparqlCxtNode;
import org.aksw.jenax.arq.util.tuple.adapter.TupleFinderOverDatasetGraph;
import org.aksw.jenax.arq.util.tuple.impl.TupleFinderSameAs;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.vocabulary.OWL;

public class DatasetGraphSameAs {
    public static DatasetGraph wrap(DatasetGraph base) {
        return DatasetGraphSameAs.wrap(base, OWL.sameAs.asNode());
    }

    public static DatasetGraph wrap(DatasetGraph base, Node sameAsPredicate) {
        return DatasetGraphSameAs.wrap(base, Collections.singleton(sameAsPredicate), false);
    }

    public static DatasetGraph wrap(DatasetGraph base, Set<Node> sameAsPredicates) {
        return DatasetGraphSameAs.wrap(base, sameAsPredicates, false);
    }

    public static DatasetGraph wrap(DatasetGraph base, Set<Node> sameAsPredicates, boolean allowDuplicates) {
        return DatasetGraphOverTupleFinder.wrap(base, TupleFinderSameAs.wrap(TupleFinderOverDatasetGraph.wrap(base, SparqlCxtNode.get()::isAnyNamedGraph), SparqlCxtNode.get(), sameAsPredicates, allowDuplicates));
    }

    public static DatasetGraph wrapWithTable(DatasetGraph base) {
        return DatasetGraphSameAs.wrapWithTable(base, OWL.sameAs.asNode(), false);
    }

    public static DatasetGraph wrapWithTable(DatasetGraph base, Node sameAsPredicate) {
        return DatasetGraphSameAs.wrapWithTable(base, Collections.singleton(sameAsPredicate), false);
    }

    public static DatasetGraph wrapWithTable(DatasetGraph base, Node sameAsPredicate, boolean allowDuplicates) {
        return DatasetGraphSameAs.wrapWithTable(base, Collections.singleton(sameAsPredicate), allowDuplicates);
    }

    public static DatasetGraph wrapWithTable(DatasetGraph base, Set<Node> sameAsPredicates, boolean allowDuplicates) {
        DatasetGraphCache cache = DatasetGraphCache.table(base, CachePatterns.forNeigborsByPredicates(sameAsPredicates));
        BiPredicate<Node, Node> mayHaveSameAsLinks = (g, n) -> {
            boolean r = false;
            for (Node p : sameAsPredicates) {
                boolean mayHaveOutLinks = cache.mayContainQuad((Node)g, (Node)n, p, Node.ANY);
                boolean mayHaveInLinks = cache.mayContainQuad((Node)g, Node.ANY, p, (Node)n);
                r = mayHaveInLinks || mayHaveOutLinks;
                if (!r) continue;
                break;
            }
            return r;
        };
        return DatasetGraphOverTupleFinder.wrap(base, TupleFinderSameAs.wrap(TupleFinderOverDatasetGraph.wrap((DatasetGraph)cache, SparqlCxtNode.get()::isAnyNamedGraph), SparqlCxtNode.get(), sameAsPredicates, allowDuplicates, mayHaveSameAsLinks));
    }
}

