package org.aksw.jenax.arq.util.prefix;

import java.util.Map;

import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;
import org.apache.jena.shared.PrefixMapping;


/**
 * A PrefixMap adapter implementation that does not scan all prefixes
 * unlike the original official {@link org.apache.jena.riot.system.PrefixMapAdapter}
 * and instead relies on the delegate. This class works efficiently with
 * PrefixMappingTrie at the cost of possibly yielding different results.
 *
 *
 * @author raven
 *
 */
@Deprecated // Jena now has it
public class PrefixMapAdapter
    extends PrefixMapBase
{
    protected PrefixMapping prefixMapping;

    public PrefixMapAdapter(PrefixMapping prefixMapping) {
        super();
        this.prefixMapping = prefixMapping;
    }

    @Override
    public Map<String, String> getMapping() {
        return prefixMapping.getNsPrefixMap();
    }

    @Override
    public void add(String prefix, String iriString) {
        prefixMapping.setNsPrefix(prefix, iriString);
    }

    @Override
    public void delete(String prefix) {
        prefixMapping.removeNsPrefix(prefix);
    }

    @Override
    public void clear() {
        prefixMapping.clearNsPrefixMap();
    }

    @Override
    public boolean containsPrefix(String prefix) {
        return prefixMapping.getNsPrefixURI(prefix) != null;
    }

    @Override
    public String abbreviate(String uriStr) {
        String tmp = prefixMapping.shortForm(uriStr);

        // Abbreviate should return null if there is no mapping
        // Conversely, the default implementation of shortForm returns its
        // argument if there is no entry - we rely on this to map the result
        // back to null
        String result = tmp == uriStr ? null : tmp;
        return result;
    }

    @Override
    public Pair<String, String> abbrev(String uriStr) {
        Pair<String, String> result = null;
        String shortForm = prefixMapping.shortForm(uriStr);

        // Note: Contract of shortForm forbids null result
        if (shortForm != uriStr) {
            int splitPoint = shortForm.indexOf(':');
            if (splitPoint >= 0) {
                String prefix = shortForm.substring(0, splitPoint);

                // Validate the prefix for robustness:
                // The split may fail if a prefix already contained a colon
                if (prefixMapping.getNsPrefixURI(prefix) != null) {
                    String localName = shortForm.substring(splitPoint + 1);
                    result = Pair.create(prefix, localName);
                }
            }
        }

        return result;
    }

    @Override
    public String expand(String prefix, String localName) {
        String iri = prefixMapping.getNsPrefixURI(prefix);
        String result = iri != null
                ? iri + localName
                : null;

        return result;
    }

    @Override
    public boolean isEmpty() {
        return prefixMapping.hasNoMappings();
    }

    @Override
    public int size() {
        return prefixMapping.numPrefixes();
    }

    public static PrefixMap wrap(PrefixMapping prefixMapping) {
        return new PrefixMapAdapter(prefixMapping);
    }

    @Override
    public String get(String prefix) {
        return prefixMapping.getNsPrefixURI(prefix);
    }
}

