/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.syntax;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.binding.BindingOverMapMutable;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformSubstitute;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;

public class VarExprListUtils {
    public static Binding eval(VarExprList exprs, Binding binding, FunctionEnv execCxt) {
        BindingOverMapMutable mb = BindingOverMapMutable.copyOf(binding);
        for (Var v : exprs.getVars()) {
            Node n = exprs.get(v, (Binding)mb, execCxt);
            if (n == null) continue;
            Node n2 = mb.get(v);
            if (n2 != null) {
                if (n2.sameValueAs((Object)n)) continue;
                return null;
            }
            mb.add(v, n);
        }
        Binding result = BindingBuilder.create().addAll((Binding)mb).build();
        return result;
    }

    public static Stream<Map.Entry<Var, Expr>> streamVarExprs(VarExprList vel) {
        return vel.getVars().stream().map(v -> new AbstractMap.SimpleEntry<Var, Expr>((Var)v, vel.getExpr(v)));
    }

    public static VarExprList projectAllVars(VarExprList vel, Collection<Var> vars) {
        VarExprList result = new VarExprList();
        for (Var var : vars) {
            Expr expr = vel.getExpr(var);
            if (expr == null) {
                result.add(var);
                continue;
            }
            result.add(var, expr);
        }
        return result;
    }

    public static VarExprList projectExprsOnly(VarExprList vel, Collection<Var> vars) {
        VarExprList result = new VarExprList();
        for (Var var : vars) {
            Expr expr = vel.getExpr(var);
            if (expr == null) continue;
            result.add(var, expr);
        }
        return result;
    }

    public static Binding copyProject(VarExprList vars, Binding binding, ExecutionContext execCxt) {
        BindingBuilder x = BindingBuilder.create();
        VarExprListUtils.copyProject(x, vars, binding, execCxt);
        return x.build();
    }

    public static void copyProject(BindingBuilder x, VarExprList vars, Binding binding, ExecutionContext execCxt) {
        for (Var var : vars.getVars()) {
            Node node = vars.get(var, binding, (FunctionEnv)execCxt);
            if (node == null) continue;
            x.add(var, node);
        }
    }

    public static VarExprList addAbsentVars(VarExprList varExprList, Collection<Var> vars) {
        for (Var var : vars) {
            if (varExprList.contains(var)) continue;
            varExprList.add(var);
        }
        return varExprList;
    }

    public static SetMultimap<Expr, Var> invert(VarExprList vel) {
        HashMultimap result = HashMultimap.create();
        for (Var v : vel.getVars()) {
            Expr expr = vel.getExpr(v);
            Expr effectiveExpr = expr == null ? new ExprVar(v) : expr;
            result.put((Object)effectiveExpr, (Object)v);
        }
        return result;
    }

    public static Map<Var, Node> extractConstants(VarExprList vel) {
        LinkedHashMap<Var, Node> result = new LinkedHashMap<Var, Node>();
        for (Var var : vel.getVars()) {
            Expr expr = vel.getExpr(var);
            if (!expr.isConstant()) continue;
            Node node = expr.getConstant().asNode();
            result.put(var, node);
        }
        return result;
    }

    public static boolean hasExprs(VarExprList vel) {
        VarExprList copy = VarExprListUtils.createFromMap(vel.getExprs());
        boolean result = !copy.getExprs().isEmpty();
        return result;
    }

    public static boolean canonicalize(VarExprList vel) {
        boolean result = false;
        Map map = vel.getExprs();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Expr x;
            Map.Entry e = it.next();
            Var v = (Var)e.getKey();
            if (!ExprUtils.isSame((Node)v, x = (Expr)e.getValue())) continue;
            it.remove();
            result = true;
        }
        return result;
    }

    public static VarExprList add(VarExprList result, Var v, Expr e) {
        if (e == null || ExprUtils.isSame((Node)v, e)) {
            result.add(v);
        } else {
            result.add(v, e);
        }
        return result;
    }

    public static VarExprList add(VarExprList result, Var v, Var w) {
        if (v.equals((Object)w)) {
            result.add(v);
        } else {
            result.add(v, (Expr)new ExprVar(w));
        }
        return result;
    }

    public static VarExprList createFromMap(Map<Var, Expr> map) {
        VarExprList result = new VarExprList();
        for (Map.Entry<Var, Expr> e : map.entrySet()) {
            Var v = e.getKey();
            Expr w = e.getValue();
            VarExprListUtils.add(result, v, w);
        }
        return result;
    }

    public static VarExprList createFromVarMap(Map<Var, Var> varMap) {
        VarExprList result = new VarExprList();
        for (Map.Entry<Var, Var> e : varMap.entrySet()) {
            Var v = e.getKey();
            Var w = e.getValue();
            VarExprListUtils.add(result, w, v);
        }
        return result;
    }

    public static Set<Var> getDefinedVars(VarExprList vel) {
        Set result = VarExprListUtils.definedVars(new LinkedHashSet(), vel);
        return result;
    }

    public static <T extends Collection<Var>> T definedVars(T acc, VarExprList vel) {
        acc.addAll(vel.getVars());
        return acc;
    }

    public static Set<Var> getVarsMentionedInBody(VarExprList vel) {
        Set result = VarExprListUtils.varsMentionedInBody(new LinkedHashSet(), vel);
        return result;
    }

    public static <T extends Collection<Var>> T varsMentionedInBody(T acc, VarExprList vel) {
        for (Map.Entry entry : vel.getExprs().entrySet()) {
            Expr e = (Expr)entry.getValue();
            if (e == null) continue;
            ExprVars.varsMentioned(acc, (Expr)e);
        }
        return acc;
    }

    public static Set<Var> getVarsMentioned(VarExprList vel) {
        Set result = VarExprListUtils.varsMentioned(new LinkedHashSet(), vel);
        return result;
    }

    public static <T extends Collection<Var>> T varsMentioned(T acc, VarExprList vel) {
        for (Var v : vel.getVars()) {
            Expr e = vel.getExpr(v);
            acc.add((Var)v);
            if (e == null) continue;
            ExprVars.varsMentioned(acc, (Expr)e);
        }
        return acc;
    }

    @Deprecated
    public static Set<Var> getRefVars(VarExprList vel) {
        HashSet<Var> result = new HashSet<Var>();
        for (Map.Entry entry : vel.getExprs().entrySet()) {
            if (entry.getValue() == null) {
                result.add((Var)entry.getKey());
                continue;
            }
            Set vs = ExprVars.getVarsMentioned((Expr)((Expr)entry.getValue()));
            result.addAll(vs);
        }
        return result;
    }

    private static Expr transform(Expr expr, ExprTransform exprTransform) {
        if (expr == null || exprTransform == null) {
            return expr;
        }
        return ExprTransformer.transform((ExprTransform)exprTransform, (Expr)expr);
    }

    public static VarExprList transform(VarExprList vel, NodeTransform nodeTransform) {
        VarExprList result = new VarExprList();
        for (Var v : vel.getVars()) {
            Expr e = vel.getExpr(v);
            Var newV = (Var)nodeTransform.apply((Object)v);
            Expr newExpr = e == null ? null : ExprUtils.applyNodeTransform(e, nodeTransform);
            result.add(newV, newExpr);
        }
        return result;
    }

    public static Map<Var, Expr> applyNodeTransform(Map<Var, Expr> varExpr, NodeTransform nodeTransform) {
        Map result = varExpr.entrySet().stream().collect(Collectors.toMap(e -> (Var)nodeTransform.apply((Object)((Node)e.getKey())), e -> ((Expr)e.getValue()).applyNodeTransform(nodeTransform), (u, v) -> {
            throw new RuntimeException("Duplicate key");
        }, LinkedHashMap::new));
        return result;
    }

    public static VarExprList transform(VarExprList varExpr, ExprTransform exprTransform) {
        List vars = varExpr.getVars();
        VarExprList varExpr2 = new VarExprList();
        boolean changed = false;
        for (Var v : vars) {
            Expr e;
            Expr newVE = exprTransform.transform(new ExprVar(v));
            Var newV = newVE == null ? v : ((ExprVar)newVE).asVar();
            changed = changed || !v.equals((Object)newV);
            Expr e2 = e = varExpr.getExpr(v);
            if (e != null) {
                e2 = VarExprListUtils.transform(e, exprTransform);
            }
            if (e2 == null) {
                varExpr2.add(newV);
            } else {
                varExpr2.add(newV, e2);
            }
            if (e == e2) continue;
            changed = true;
        }
        if (!changed) {
            return varExpr;
        }
        return varExpr2;
    }

    public static ExprTransform createExprTransform(Map<Var, Expr> varDefs) {
        Map tmp = varDefs.entrySet().stream().collect(Collectors.toMap(e -> ((Var)e.getKey()).getName(), Map.Entry::getValue, (u, v) -> {
            throw new RuntimeException("duplicate");
        }, LinkedHashMap::new));
        ExprTransformSubstitute result = new ExprTransformSubstitute(tmp);
        return result;
    }

    public static void replace(VarExprList dst, VarExprList src) {
        if (dst != src) {
            dst.clear();
            VarExprListUtils.copy(dst, src);
        }
    }

    public static VarExprList copy(VarExprList dst, VarExprList src) {
        for (Var v : src.getVars()) {
            Expr e = src.getExpr(v);
            if (e == null) {
                dst.add(v);
                continue;
            }
            dst.add(v, e);
        }
        return dst;
    }
}

