/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.exec.query;

import org.apache.jena.query.Query;

public class QueryPaginator {
    private long nextOffset;
    private Long nextRemaining;
    private Query query;

    public QueryPaginator(Query query) {
        this(query, null);
    }

    public QueryPaginator(Query query, Long nextOffset) {
        this.query = query;
        this.nextOffset = query.getOffset() == Long.MIN_VALUE ? 0L : query.getOffset();
        this.nextRemaining = query.getLimit() == Long.MIN_VALUE ? null : Long.valueOf(query.getLimit());
    }

    public Query nextPage(long pageSize) {
        if (this.nextOffset == 0L) {
            this.query.setOffset(Long.MIN_VALUE);
        } else {
            this.query.setOffset(this.nextOffset);
        }
        if (this.nextRemaining == null) {
            this.query.setLimit(pageSize);
            this.nextOffset += pageSize;
        } else {
            long limit = Math.min(pageSize, this.nextRemaining);
            this.nextOffset += limit;
            this.nextRemaining = this.nextRemaining - limit;
            if (limit == 0L) {
                return null;
            }
            this.query.setLimit(limit);
        }
        return this.query;
    }
}

