/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.util.cache.CacheUtils;
import org.aksw.jenax.arq.dataset.cache.CachePattern;
import org.aksw.jenax.arq.util.dataset.DatasetGraphWrapperFindBase;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphCache
extends DatasetGraphWrapperFindBase {
    private static final Logger logger = LoggerFactory.getLogger(DatasetGraphCache.class);
    public static boolean logCacheStats = false;
    protected long findCounter = 0L;
    protected Supplier<Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>>> cacheFactory;
    protected Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>> cache;
    protected AtomicLong cacheVersion = new AtomicLong(-1L);
    protected volatile long cacheGeneration = 0L;
    protected boolean isTablingMode = false;
    protected Collection<CachePattern> cachePatterns;
    public static final int DFT_MAX_CACHE_SIZE = 10000;

    public static DatasetGraphCache cache(DatasetGraph base, Collection<CachePattern> cachePatterns) {
        return DatasetGraphCache.cache(base, cachePatterns, 10000);
    }

    public static DatasetGraphCache cache(DatasetGraph base, Collection<CachePattern> cachePatterns, int maxCacheSize) {
        return DatasetGraphCache.create(base, cachePatterns, maxCacheSize, false);
    }

    public static DatasetGraphCache table(DatasetGraph base, CachePattern cachePatterns) {
        return DatasetGraphCache.table(base, Collections.singletonList(cachePatterns));
    }

    public static DatasetGraphCache table(DatasetGraph base, Collection<CachePattern> cachePatterns) {
        return DatasetGraphCache.create(base, cachePatterns, Long.MAX_VALUE, true);
    }

    public static DatasetGraphCache create(DatasetGraph base, Collection<CachePattern> cachePatterns, long maxCacheSize, boolean isTablingMode) {
        Supplier<Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>>> cacheFactory = () -> CacheUtils.recordStats((CacheBuilder)CacheBuilder.newBuilder(), (boolean)logCacheStats).maximumSize(maxCacheSize).build();
        return new DatasetGraphCache(base, cachePatterns, cacheFactory, isTablingMode);
    }

    protected DatasetGraphCache(DatasetGraph base, Collection<CachePattern> cachePatterns, Supplier<Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>>> cacheFactory, boolean isTablingMode) {
        super(base);
        this.cachePatterns = cachePatterns;
        this.cacheFactory = cacheFactory;
        this.isTablingMode = isTablingMode;
        if (!isTablingMode) {
            this.cache = cacheFactory.get();
        }
    }

    public boolean isTablingMode() {
        return this.isTablingMode;
    }

    public boolean mayContainQuad(Node g, Node s, Node p, Node o) {
        return this.mayContainQuad(Quad.create((Node)g, (Node)s, (Node)p, (Node)o));
    }

    protected void nextGeneration() {
        ++this.cacheGeneration;
    }

    public void add(Node g, Node s, Node p, Node o) {
        this.getW().add(g, s, p, o);
        this.nextGeneration();
    }

    public void delete(Node g, Node s, Node p, Node o) {
        this.getW().add(g, s, p, o);
        this.nextGeneration();
    }

    public void addAll(DatasetGraph src) {
        this.getW().addAll(src);
        this.nextGeneration();
    }

    public void deleteAny(Node g, Node s, Node p, Node o) {
        this.getW().deleteAny(g, s, p, o);
        this.nextGeneration();
    }

    public void add(Quad quad) {
        this.getW().add(quad);
        this.nextGeneration();
    }

    public void delete(Quad quad) {
        this.getW().delete(quad);
        this.nextGeneration();
    }

    public void abort() {
        this.nextGeneration();
    }

    public boolean mayContainQuad(Quad rawQuad) {
        boolean result = true;
        if (this.isTablingMode) {
            Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>> currentCache = this.ensureFilledTables();
            Quad quad = Quad.isDefaultGraphGenerated((Node)rawQuad.getGraph()) ? Quad.create((Node)Quad.defaultGraphIRI, (Triple)rawQuad.asTriple()) : rawQuad;
            for (CachePattern pattern : this.cachePatterns) {
                if (!pattern.subsumes(quad)) continue;
                Tuple<Node> key = pattern.createPartitionKey(quad);
                Set partition = (Set)CacheUtils.getIfPresent(currentCache, Map.entry(pattern.getSpecPattern(), key));
                if (partition == null || partition.isEmpty()) {
                    result = false;
                    break;
                }
                if (!quad.isConcrete() || (result = partition.contains(quad))) continue;
                break;
            }
        }
        return result;
    }

    protected Stream<CachePattern> getMatchingCachePatterns(Node mg, Node ms, Node mp, Node mo) {
        return this.cachePatterns.stream().filter(pattern -> pattern.matchesPattern(mg, ms, mp, mo));
    }

    protected Stream<CachePattern> getSuperPatterns(Node mg, Node ms, Node mp, Node mo) {
        return this.cachePatterns.stream().filter(pattern -> pattern.subsumes(mg, ms, mp, mo));
    }

    @Override
    protected Iterator<Quad> actionFind(boolean ng, Node mg, Node ms, Node mp, Node mo) {
        Iterator<Object> result;
        Node lookupGraph;
        CachePattern cachePattern;
        if (logCacheStats) {
            ++this.findCounter;
            if (this.findCounter % 100000L == 0L) {
                System.err.println(CacheUtils.stats(this.cache));
            }
        }
        if ((cachePattern = (CachePattern)this.getMatchingCachePatterns(lookupGraph = Quad.isDefaultGraphGenerated((Node)mg) ? Quad.defaultGraphIRI : mg, ms, mp, mo).findFirst().orElse(null)) != null) {
            Tuple<Node> partitionKey = cachePattern.createPartitionKey(lookupGraph, ms, mp, mo);
            Map.Entry<Quad, Tuple<Node>> key = Map.entry(cachePattern.getSpecPattern(), partitionKey);
            Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>> currentCache = this.ensureFilledTables();
            if (this.isTablingMode) {
                this.ensureFilledTables();
                Collection bucket = (Collection)CacheUtils.getIfPresent(currentCache, key);
                result = bucket == null ? Collections.emptyIterator() : bucket.iterator();
            } else {
                result = ((Set)CacheUtils.get(this.cache, key, () -> (Set)Iter.iter(this.delegateFind(ng, mg, ms, mp, mo)).collect(Collectors.toCollection(LinkedHashSet::new)))).iterator();
            }
        } else {
            result = this.delegateFind(ng, mg, ms, mp, mo);
        }
        return result;
    }

    public Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>> ensureFilledTables() {
        Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>> result;
        long gen;
        long ver = this.cacheVersion.get();
        if (ver != (gen = this.cacheGeneration)) {
            if (this.isTablingMode) {
                result = this.refreshTables();
                if (this.cacheVersion.compareAndSet(ver, gen)) {
                    this.cache = result;
                }
            } else {
                this.cache.invalidateAll();
                this.cacheVersion.compareAndSet(ver, gen);
                result = this.cache;
            }
        } else {
            result = this.cache;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>> refreshTables() {
        Cache<Map.Entry<Quad, Tuple<Node>>, Set<Quad>> result = this.cacheFactory.get();
        for (CachePattern cachePattern : this.cachePatterns) {
            Quad sp = cachePattern.getSpecPattern();
            Quad baseFp = cachePattern.getFindPattern();
            List<Quad> lookups = Arrays.asList(baseFp, Quad.create((Node)Quad.unionGraph, (Triple)baseFp.asTriple()));
            for (Quad fp : lookups) {
                Iterator<Quad> it = this.delegateFind(false, fp.getGraph(), fp.getSubject(), fp.getPredicate(), fp.getObject());
                try {
                    LinkedHashSet<Node> seenGraphs = new LinkedHashSet<Node>();
                    long counter = 0L;
                    while (it.hasNext()) {
                        Quad quad = it.next();
                        ++counter;
                        Tuple<Node> key = cachePattern.createPartitionKey(quad);
                        Collection bucket = (Collection)CacheUtils.get(result, Map.entry(sp, key), LinkedHashSet::new);
                        bucket.add(quad);
                        seenGraphs.add(quad.getGraph());
                    }
                    logger.info("Tabeling: " + String.valueOf(fp) + " indexed " + counter + " quads in " + seenGraphs.size() + " graphs, first 100: " + String.valueOf(Iterables.limit(seenGraphs, (int)100)));
                }
                finally {
                    Iter.close(it);
                }
            }
        }
        return result;
    }
}

