/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple.resultset;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.aksw.jenax.arq.util.tuple.TupleOps;
import org.aksw.jenax.arq.util.tuple.resultset.ResultStreamer;
import org.apache.jena.atlas.lib.tuple.Tuple;

public class ResultStreamerFromDomain<D, C>
implements ResultStreamer<D, C, Tuple<C>> {
    protected Supplier<Stream<D>> domainStreamer;
    protected TupleBridge<D, C> domainAccessor;

    public ResultStreamerFromDomain(Supplier<Stream<D>> domainStreamer, TupleBridge<D, C> domainAccessor) {
        this.domainStreamer = domainStreamer;
        this.domainAccessor = domainAccessor;
    }

    @Override
    public Stream<D> streamAsDomainObject() {
        return this.domainStreamer.get();
    }

    @Override
    public Stream<C> streamAsComponent() {
        if (this.domainAccessor.getDimension() != 1) {
            throw new UnsupportedOperationException("Cannot stream domain objects with dimension != 1 as a component");
        }
        return this.streamAsDomainObject().map(item -> this.domainAccessor.get(item, 0));
    }

    @Override
    public Stream<Tuple<C>> streamAsTuple() {
        Function<D, Tuple<C>> tupelizer = TupleOps.tupelizer(this.domainAccessor);
        return this.streamAsDomainObject().map(tupelizer);
    }

    @Override
    public ResultStreamer.BackingType getBackingType() {
        return ResultStreamer.BackingType.DOMAIN;
    }
}

