/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.query;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.core.Quad;

public class OpVisitorTriplesQuads
extends OpVisitorBase {
    protected List<Triple> triples;
    protected List<Quad> quads;

    public static List<Quad> extractQuadsSafe(Op op) {
        OpVisitorTriplesQuads visitor = new OpVisitorTriplesQuads();
        op.visit((OpVisitor)visitor);
        List<Quad> result = visitor.forceGetQuadList();
        return result;
    }

    public static Stream<Quad> streamQuads(Op op) {
        return OpVisitorTriplesQuads.extractQuadsSafe(op).stream();
    }

    protected boolean isTriplesOrQuads() {
        return this.quads != null || this.triples != null;
    }

    public List<Triple> getTriples() {
        return this.triples;
    }

    public List<Quad> getQuads() {
        return this.quads;
    }

    public List<Quad> forceGetQuadList() {
        List<Quad> result = this.triples != null ? this.triples.stream().map(t -> new Quad(Quad.defaultGraphNodeGenerated, t)).collect(Collectors.toList()) : (this.quads != null ? this.quads : Collections.emptyList());
        return result;
    }

    public void visit(OpTriple op) {
        this.triples = Collections.singletonList(op.getTriple());
    }

    public void visit(OpBGP op) {
        this.triples = op.getPattern().getList();
    }

    public void visit(OpQuad op) {
        this.quads = Collections.singletonList(op.getQuad());
    }

    public void visit(OpQuadPattern op) {
        this.quads = op.getPattern().getList();
    }

    public void visit(OpQuadBlock op) {
        this.quads = op.getPattern().getList();
    }
}

