/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.NodeCmp;

public class ComparableNodeValue
implements Comparable<ComparableNodeValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Node node;
    protected transient NodeValue nodeValue;

    ComparableNodeValue() {
    }

    protected ComparableNodeValue(Node node, NodeValue nodeValue) {
        this.node = node;
        this.nodeValue = nodeValue;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ComparableNodeValue obj = (ComparableNodeValue)ois.readObject();
        obj.nodeValue = NodeValue.makeNode((Node)obj.node);
    }

    public Node getNode() {
        return this.node;
    }

    public NodeValue getNodeValue() {
        return this.nodeValue;
    }

    public static ComparableNodeValue wrap(Node node) {
        return new ComparableNodeValue(node, NodeValue.makeNode((Node)node));
    }

    public static ComparableNodeValue wrap(NodeValue nodeValue) {
        return new ComparableNodeValue(nodeValue.asNode(), nodeValue);
    }

    @Override
    public int compareTo(ComparableNodeValue that) {
        int result;
        try {
            result = NodeValue.compare((NodeValue)this.nodeValue, (NodeValue)that.nodeValue);
        }
        catch (ExprNotComparableException e) {
            result = NodeCmp.compareRDFTerms((Node)this.node, (Node)that.node);
        }
        return result;
    }

    public String toString() {
        return this.node.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparableNodeValue other = (ComparableNodeValue)obj;
        return !(this.node == null ? other.node != null : !this.node.equals((Object)other.node));
    }
}

