/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.algebra.walker;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathStr;
import org.apache.jena.sparql.algebra.Op;

public class Tracker<T> {
    protected Path<String> path = PathStr.newAbsolutePath((String[])new String[0]);
    protected Map<Path<String>, Op> pathToOp = new LinkedHashMap<Path<String>, Op>();
    protected Map<Path<String>, T> pathToData;
    protected Multimap<Path<String>, Path<String>> parentToChildren = ArrayListMultimap.create();

    public Tracker() {
        this.pathToData = new HashMap<Path<String>, T>();
    }

    public static <T> Tracker<T> create(Op rootOp) {
        Tracker<T> result = new Tracker<T>();
        result.getPathToOp().put(result.getPath(), rootOp);
        return result;
    }

    public Path<String> getPath() {
        return this.path;
    }

    public Map<Path<String>, Op> getPathToOp() {
        return this.pathToOp;
    }

    public Multimap<Path<String>, Path<String>> getParentToChildren() {
        return this.parentToChildren;
    }

    public void setPath(Path<String> path) {
        this.path = path;
    }

    public void setPathToOp(Map<Path<String>, Op> pathToOp) {
        this.pathToOp = pathToOp;
    }

    public void setParentToChildren(Multimap<Path<String>, Path<String>> parentToChildren) {
        this.parentToChildren = parentToChildren;
    }

    public Map<Path<String>, T> getData() {
        return this.pathToData;
    }

    public void put(T value) {
        this.put(this.path, value);
    }

    public T get() {
        return this.get(this.path);
    }

    public Path<String> getChildPath(int childIndex) {
        return this.getChildPath(this.path, childIndex);
    }

    public Path<String> getChildPath(Path<String> parent, int childIndex) {
        List children = (List)this.parentToChildren.get(parent);
        Path result = (Path)children.get(childIndex);
        return result;
    }

    public T computeIfAbsent(Function<? super Path<String>, ? extends T> fn) {
        return this.pathToData.computeIfAbsent(this.path, fn);
    }

    public void put(Path<String> path, T value) {
        this.pathToData.put(path, value);
    }

    public T get(Object path) {
        return this.pathToData.get(path);
    }
}

