/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.algebra.walker;

import org.aksw.commons.path.core.Path;
import org.aksw.jenax.sparql.algebra.walker.Tracker;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.walker.ExprVisitorFunction;
import org.apache.jena.sparql.algebra.walker.OpVisitorByTypeAndExpr;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprTripleTerm;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;

public class TrackingWalkerVisitor
implements OpVisitorByTypeAndExpr,
ExprVisitorFunction {
    protected final ExprVisitor exprVisitor;
    protected final OpVisitor opVisitor;
    protected int opDepthLimit = Integer.MAX_VALUE;
    protected int exprDepthLimit = Integer.MAX_VALUE;
    protected int opDepth = 0;
    protected int exprDepth = 0;
    private final OpVisitor beforeVisitor;
    private final OpVisitor afterVisitor;
    protected Tracker<?> tracker;

    public static String getLabel(Op op) {
        return op.getName();
    }

    public void pushPath(String parentLabel, Op op) {
        Path<String> parent = this.tracker.getPath();
        Path path = parent.resolve((Object)parentLabel);
        this.tracker.setPath((Path<String>)path);
        this.tracker.getPathToOp().put((Path<String>)path, op);
        this.tracker.getParentToChildren().put(parent, (Object)path);
    }

    public void popPath() {
        this.tracker.setPath((Path<String>)this.tracker.getPath().getParent());
    }

    public TrackingWalkerVisitor(Tracker<?> tracker, OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor before, OpVisitor after) {
        this.opVisitor = opVisitor;
        this.exprVisitor = exprVisitor;
        if (this.opDepthLimit < 0) {
            this.opDepthLimit = Integer.MAX_VALUE;
        }
        if (this.exprDepth < 0) {
            this.exprDepthLimit = Integer.MAX_VALUE;
        }
        this.opDepth = 0;
        this.exprDepth = 0;
        this.beforeVisitor = before;
        this.afterVisitor = after;
        this.tracker = tracker;
    }

    protected final void before(Op op) {
        if (this.beforeVisitor != null) {
            op.visit(this.beforeVisitor);
        }
    }

    protected final void after(Op op) {
        if (this.afterVisitor != null) {
            op.visit(this.afterVisitor);
        }
    }

    public void walk(Op op) {
        if (op == null) {
            return;
        }
        if (this.opDepth == this.opDepthLimit) {
            return;
        }
        ++this.opDepth;
        try {
            op.visit((OpVisitor)this);
        }
        finally {
            --this.opDepth;
        }
    }

    public void walk(Expr expr) {
        if (expr == null) {
            return;
        }
        if (this.exprDepth == this.exprDepthLimit) {
            return;
        }
        ++this.exprDepth;
        try {
            expr.visit((ExprVisitor)this);
        }
        finally {
            --this.exprDepth;
        }
    }

    public void walk(ExprList exprList) {
        if (exprList == null) {
            return;
        }
        exprList.forEach(e -> this.walk((Expr)e));
    }

    public void walk(VarExprList varExprList) {
        if (varExprList == null) {
            return;
        }
        varExprList.forEachVarExpr((v, e) -> {
            Expr expr = e != null ? e : Expr.NONE;
            this.walk(expr);
        });
    }

    public void visitExpr(ExprList exprList) {
        if (this.exprVisitor != null) {
            this.walk(exprList);
        }
    }

    public void visitVarExpr(VarExprList varExprList) {
        if (this.exprVisitor != null) {
            this.walk(varExprList);
        }
    }

    public void visitOp(Op op) {
        this.before(op);
        if (this.opVisitor != null) {
            op.visit((OpVisitor)this);
        }
        this.after(op);
    }

    public void visit0(Op0 op) {
        this.before((Op)op);
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
        this.after((Op)op);
    }

    public void visit1(Op1 op) {
        this.before((Op)op);
        this.visit1$(op);
        this.after((Op)op);
    }

    private void visit1$(Op1 op) {
        String parentLabel = TrackingWalkerVisitor.getLabel((Op)op);
        if (op.getSubOp() != null) {
            this.pushPath(parentLabel, op.getSubOp());
            op.getSubOp().visit((OpVisitor)this);
            this.popPath();
        }
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
    }

    public void visit2(Op2 op) {
        String parentLabel = TrackingWalkerVisitor.getLabel((Op)op);
        this.before((Op)op);
        if (op.getLeft() != null) {
            this.pushPath(parentLabel + "0", op.getLeft());
            op.getLeft().visit((OpVisitor)this);
            this.popPath();
        }
        if (op.getRight() != null) {
            this.pushPath(parentLabel + "1", op.getRight());
            op.getRight().visit((OpVisitor)this);
            this.popPath();
        }
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
        this.after((Op)op);
    }

    public void visitN(OpN op) {
        String parentLabel = TrackingWalkerVisitor.getLabel((Op)op);
        this.before((Op)op);
        int i = 0;
        for (Op sub : op) {
            String childLabel = parentLabel + i;
            this.pushPath(childLabel, sub);
            sub.visit((OpVisitor)this);
            this.popPath();
            ++i;
        }
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
        this.after((Op)op);
    }

    public void visitExt(OpExt op) {
        this.before((Op)op);
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
        this.after((Op)op);
    }

    public void visit(OpOrder opOrder) {
        this.visit1((Op1)opOrder);
    }

    public void visit(OpAssign opAssign) {
        this.before((Op)opAssign);
        VarExprList varExpr = opAssign.getVarExprList();
        this.visitVarExpr(varExpr);
        this.visit1$((Op1)opAssign);
        this.after((Op)opAssign);
    }

    public void visit(OpExtend opExtend) {
        this.before((Op)opExtend);
        VarExprList varExpr = opExtend.getVarExprList();
        this.visitVarExpr(varExpr);
        this.visit1$((Op1)opExtend);
        this.after((Op)opExtend);
    }

    public void visit(ExprFunction0 func) {
        this.visitExprFunction((ExprFunction)func);
    }

    public void visit(ExprFunction1 func) {
        this.visitExprFunction((ExprFunction)func);
    }

    public void visit(ExprFunction2 func) {
        this.visitExprFunction((ExprFunction)func);
    }

    public void visit(ExprFunction3 func) {
        this.visitExprFunction((ExprFunction)func);
    }

    public void visit(ExprFunctionN func) {
        this.visitExprFunction((ExprFunction)func);
    }

    public void visitExprFunction(ExprFunction func) {
        for (int i = 1; i <= func.numArgs(); ++i) {
            Expr expr = func.getArg(i);
            if (expr == null) {
                Expr.NONE.visit((ExprVisitor)this);
                continue;
            }
            expr.visit((ExprVisitor)this);
        }
        if (this.exprVisitor != null) {
            func.visit(this.exprVisitor);
        }
    }

    public void visit(ExprFunctionOp funcOp) {
        this.walk(funcOp.getGraphPattern());
        if (this.exprVisitor != null) {
            funcOp.visit(this.exprVisitor);
        }
    }

    public void visit(NodeValue nv) {
        if (this.exprVisitor != null) {
            nv.visit(this.exprVisitor);
        }
    }

    public void visit(ExprTripleTerm exTripleTerm) {
        if (this.exprVisitor != null) {
            exTripleTerm.visit(this.exprVisitor);
        }
    }

    public void visit(ExprVar v) {
        if (this.exprVisitor != null) {
            v.visit(this.exprVisitor);
        }
    }

    public void visit(ExprNone none) {
        if (this.exprVisitor != null) {
            none.visit(this.exprVisitor);
        }
    }

    public void visit(ExprAggregator eAgg) {
        this.visitAssignVar(eAgg.getAggVar().asVar());
        if (this.exprVisitor != null) {
            eAgg.visit(this.exprVisitor);
        }
    }
}

