/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.algebra.optimize;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aksw.commons.path.core.Path;
import org.aksw.jenax.arq.util.expr.DnfUtils;
import org.aksw.jenax.constraint.api.CBinding;
import org.aksw.jenax.constraint.api.VSpace;
import org.aksw.jenax.constraint.impl.CBindingMap;
import org.aksw.jenax.constraint.util.ConstraintDerivations;
import org.aksw.jenax.sparql.algebra.walker.Tracker;
import org.aksw.jenax.sparql.algebra.walker.TrackingTransformCopy;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorByTypeBase;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.ValueSpace;
import org.apache.jena.sparql.util.ExprUtils;

public class TrackingTransformConditionalFunctionInversion
extends TrackingTransformCopy<CBinding> {
    protected BeforeVisitor beforeVisitor;
    protected Map<Path<String>, Map<Expr, VSpace>> beforeConditions = new LinkedHashMap<Path<String>, Map<Expr, VSpace>>();
    protected Map<Path<String>, Map<Expr, VSpace>> afterConditions = new LinkedHashMap<Path<String>, Map<Expr, VSpace>>();

    public TrackingTransformConditionalFunctionInversion(Tracker<CBinding> pathState) {
        super(pathState);
        this.beforeVisitor = new BeforeVisitor();
    }

    @Override
    public OpVisitor getBeforeVisitor() {
        return this.beforeVisitor;
    }

    public Op transform(OpBGP opBGP) {
        CBinding crow = this.tracker.computeIfAbsent(p -> CBindingMap.create());
        for (Triple triple : opBGP.getPattern()) {
            ConstraintDerivations.deriveConstraints((CBinding)crow, (Triple)triple);
        }
        Path<String> path = this.tracker.getPath();
        Map<Expr, VSpace> evsMap = TrackingTransformConditionalFunctionInversion.toExprConstraints(crow);
        this.afterConditions.put(this.tracker.getPath(), evsMap);
        return super.transform(opBGP);
    }

    public Op transform(OpFilter opFilter, Op subOp) {
        ExprList el = opFilter.getExprs();
        List dnf = DnfUtils.toListDnf((ExprList)el);
        Path<String> childPath = this.tracker.getChildPath(0);
        Map<Expr, VSpace> crow = this.afterConditions.get(childPath);
        if (crow != null) {
            for (List clause : dnf) {
                for (int i = 0; i < clause.size(); ++i) {
                    Map.Entry<NodeValue, Expr> newE;
                    Expr expr;
                    Expr effExpr = expr = (Expr)clause.get(0);
                    Map.Entry e = (Map.Entry)org.aksw.jenax.arq.util.expr.ExprUtils.applyToArgsOfBinaryExpr((Expr)expr, org.aksw.jenax.arq.util.expr.ExprUtils::tryGetConstAndExpr);
                    if (e == null || e == (newE = TrackingTransformConditionalFunctionInversion.applyInverseFunction(e, crow))) continue;
                    effExpr = org.aksw.jenax.arq.util.expr.ExprUtils.copy((Expr)expr, (Expr[])new Expr[]{newE.getValue(), (Expr)newE.getKey()});
                    clause.set(i, effExpr);
                }
            }
        }
        Expr finalExpr = DnfUtils.toExpr((Iterable)dnf);
        Op result = OpFilter.filter((Expr)finalExpr, (Op)subOp);
        return result;
    }

    public static Map<Expr, VSpace> toExprConstraints(CBinding crow) {
        HashMap<Expr, VSpace> result = new HashMap<Expr, VSpace>();
        for (Var var : crow.getVars()) {
            VSpace vs = crow.get(var);
            result.put((Expr)new ExprVar(var), vs);
        }
        return result;
    }

    public static Map.Entry<NodeValue, Expr> applyInverseFunction(Map.Entry<NodeValue, Expr> e, Map<Expr, VSpace> exprToValueSpace) {
        Map.Entry<NodeValue, Expr> result = e;
        Expr expr = e.getValue();
        if (expr instanceof ExprFunction1) {
            VSpace vs;
            ExprFunction1 fn = (ExprFunction1)expr;
            Expr arg = fn.getArg();
            if (fn instanceof E_Str && (vs = exprToValueSpace.get(arg)).isLimitedTo((Object)ValueSpace.VSPACE_URI)) {
                result = new AbstractMap.SimpleEntry<NodeValue, Expr>(ExprUtils.eval((Expr)new E_IRI((Expr)e.getKey())), arg);
            }
        }
        return result;
    }

    public class BeforeVisitor
    extends OpVisitorByTypeBase {
        public void visit(OpBGP opBGP) {
        }

        public void visit(OpFilter op) {
        }

        public void visit(OpUnion opUnion) {
        }
    }
}

