/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.tika;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrEx;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sys.JenaSystem;

public class FileTypeDetectorFromRDFLanguages
extends FileTypeDetector {
    @Override
    public String probeContentType(Path path) throws IOException {
        String result;
        boolean useLegacyApproach = false;
        if (useLegacyApproach) {
            ContentType contentType = RDFLanguages.guessContentType((String)path.toString());
            result = contentType == null ? null : contentType.getContentTypeStr();
        } else {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                RdfEntityInfo info = RDFDataMgrEx.probeEntityInfo((InputStream)in, (Iterable)RDFDataMgrEx.DEFAULT_PROBE_LANGS);
                result = info.getContentType();
            }
        }
        return result;
    }

    static {
        JenaSystem.init();
    }
}

