/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.resultset;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import org.aksw.jenax.stmt.resultset.SPARQLResultEx;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Quad;

public interface SPARQLResultVisitor {
    public void onResultSet(ResultSet var1);

    public void onJson(JsonElement var1);

    public void onQuad(Quad var1);

    public static <T extends SPARQLResultVisitor> T forward(SPARQLResultEx sr, T handler) {
        if (sr.isQuads()) {
            Iterator<Quad> it = sr.getQuads();
            while (it.hasNext()) {
                Quad t = it.next();
                handler.onQuad(t);
            }
        } else if (sr.isTriples()) {
            Iterator<Triple> it = sr.getTriples();
            while (it.hasNext()) {
                Triple t = it.next();
                Quad quad = new Quad(Quad.defaultGraphIRI, t);
                handler.onQuad(quad);
            }
        } else if (sr.isResultSet()) {
            ResultSet value = sr.getResultSet();
            handler.onResultSet(value);
        } else if (sr.isBoolean()) {
            Boolean value = sr.getBooleanResult();
            handler.onJson((JsonElement)new JsonPrimitive(value));
        } else if (sr.isJson()) {
            Gson gson = new Gson();
            Iterator it = sr.getJsonItems();
            JsonArray arr = new JsonArray();
            while (it.hasNext()) {
                org.apache.jena.atlas.json.JsonObject value = (org.apache.jena.atlas.json.JsonObject)it.next();
                String json = value.toString();
                JsonObject item = (JsonObject)gson.fromJson(json, JsonObject.class);
                arr.add((JsonElement)item);
            }
            handler.onJson((JsonElement)arr);
        } else if (!sr.isUpdateType()) {
            throw new RuntimeException("Unknown SPARQL result");
        }
        return handler;
    }
}

