/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.parser.element;

import java.util.function.Function;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.stmt.parser.element.SparqlElementParser;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserImpl;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.syntax.Element;

public class SparqlElementParserImpl
implements SparqlElementParser {
    protected Function<String, Query> queryParser;

    public SparqlElementParserImpl() {
        this(new SparqlQueryParserImpl());
    }

    public SparqlElementParserImpl(Function<String, Query> queryParser) {
        this.queryParser = queryParser;
    }

    @Override
    public Element apply(String elementStr) {
        boolean isEnclosed;
        Object tmp = elementStr.trim();
        boolean bl = isEnclosed = ((String)tmp).startsWith("{") && ((String)tmp).endsWith("}");
        if (!isEnclosed) {
            tmp = "{" + (String)tmp + "}";
        }
        tmp = "Select * " + (String)tmp;
        Query query = this.queryParser.apply((String)tmp);
        Element raw = query.getQueryPattern();
        Element result = ElementUtils.flatten((Element)raw);
        return result;
    }

    public static SparqlElementParserImpl create(Syntax syntax, Prologue prologue) {
        SparqlQueryParserImpl queryParser = SparqlQueryParserImpl.create(syntax, prologue);
        SparqlElementParserImpl result = new SparqlElementParserImpl(queryParser);
        return result;
    }
}

