/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.core;

import com.google.common.collect.Streams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.common.DefaultPrefixes;
import org.aksw.jenax.arq.util.node.NodeEnvsubst;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.aksw.jenax.stmt.resultset.SPARQLResultSinkQuads;
import org.aksw.jenax.stmt.util.SparqlStmtIterator;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.sparql.util.PrefixMapping2;

public class SparqlStmtMgr {
    public static void readDataset(Dataset dataset, String filenameOrURI, Consumer<Quad> quadConsumer) {
        RDFConnection conn = RDFConnectionFactory.connect((Dataset)dataset);
        SparqlStmtMgr.readConnection(conn, filenameOrURI, quadConsumer);
    }

    public static void readModel(Model model, String filenameOrURI, Consumer<Quad> quadConsumer) {
        Dataset dataset = DatasetFactory.wrap((Model)model);
        SparqlStmtMgr.readDataset(dataset, filenameOrURI, quadConsumer);
    }

    public static void readConnection(RDFConnection conn, String filenameOrURI, Consumer<Quad> quadConsumer) {
        SparqlStmtMgr.readConnection(conn, filenameOrURI, quadConsumer, System::getenv);
    }

    public static void execSparql(Model model, String filenameOrURI) {
        SparqlStmtMgr.execSparql(model, filenameOrURI, (Function<String, String>)null);
    }

    public static void execSparql(Model model, String filenameOrURI, Function<String, String> envLookup) {
        Dataset dataset = DatasetFactory.wrap((Model)model);
        SparqlStmtMgr.execSparql(dataset, filenameOrURI, envLookup);
    }

    public static void execSparql(Dataset dataset, String filenameOrURI) {
        SparqlStmtMgr.execSparql(dataset, filenameOrURI, (Function<String, String>)null);
    }

    public static void execSparql(Dataset dataset, String filenameOrURI, Function<String, String> envLookup) {
        try (RDFConnection conn = RDFConnection.connect((Dataset)dataset);){
            SparqlStmtMgr.execSparql(conn, filenameOrURI, envLookup);
        }
    }

    public static void execSparql(Model model, String filenameOrURI, Map<String, String> envMap) {
        try (RDFConnection conn = RDFConnection.connect((Dataset)DatasetFactory.wrap((Model)model));){
            SparqlStmtMgr.execSparql(conn, filenameOrURI, envMap == null ? null : envMap::get);
        }
    }

    public static void execSparql(RDFConnection conn, String filenameOrURI) {
        SparqlStmtMgr.readConnection(conn, filenameOrURI, null);
    }

    public static void execSparql(RDFConnection conn, String filenameOrURI, Function<String, String> envLookup) {
        SparqlStmtMgr.readConnection(conn, filenameOrURI, null, envLookup);
    }

    public static Query loadQuery(String filenameOrURI) {
        return SparqlStmtMgr.loadQuery(filenameOrURI, DefaultPrefixes.get());
    }

    public static List<Query> loadQueries(InputStream in, PrefixMapping pm) throws FileNotFoundException, IOException {
        List stmts = Streams.stream((Iterator)((Object)SparqlStmtUtils.processInputStream(pm, null, in))).collect(Collectors.toList());
        ArrayList<Query> result = new ArrayList<Query>();
        for (SparqlStmt stmt : stmts) {
            Query query = stmt.getQuery();
            query.setBaseURI((String)null);
            QueryUtils.optimizePrefixes((Query)query);
            result.add(query);
        }
        return result;
    }

    public static List<Query> loadQueries(String filenameOrURI) {
        List<Query> result;
        try {
            PrefixMapping2 pm = new PrefixMapping2(PrefixMapping.Extended);
            result = SparqlStmtMgr.loadQueries(filenameOrURI, (PrefixMapping)pm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static List<Query> loadQueries(String filenameOrURI, PrefixMapping pm) throws FileNotFoundException, IOException {
        List stmts = Streams.stream((Iterator)((Object)SparqlStmtUtils.processFile(pm, filenameOrURI))).collect(Collectors.toList());
        ArrayList<Query> result = new ArrayList<Query>();
        for (SparqlStmt stmt : stmts) {
            if (!stmt.isParsed()) {
                throw new RuntimeException(stmt.getParseException());
            }
            Query query = Objects.requireNonNull(stmt.getQuery());
            query.setBaseURI((String)null);
            QueryUtils.optimizePrefixes((Query)query);
            result.add(query);
        }
        return result;
    }

    public static Query loadQuery(String filenameOrURI, PrefixMapping pm) {
        List<Query> queries;
        try {
            queries = SparqlStmtMgr.loadQueries(filenameOrURI, pm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (queries.size() != 1) {
            throw new RuntimeException("Expected a single query in " + filenameOrURI + "; got " + queries.size());
        }
        Query result = queries.get(0);
        return result;
    }

    public static void readConnection(RDFConnection conn, String filenameOrURI, Consumer<Quad> quadConsumer, Function<String, String> envLookup) {
        PrefixMappingImpl pm = new PrefixMappingImpl();
        pm.setNsPrefixes(DefaultPrefixes.get());
        try {
            List stmts = Streams.stream((Iterator)((Object)SparqlStmtUtils.processFile((PrefixMapping)pm, filenameOrURI))).collect(Collectors.toList());
            for (SparqlStmt stmt : stmts) {
                SparqlStmt stmt2 = envLookup == null ? stmt : SparqlStmtUtils.applyNodeTransform(stmt, x -> NodeEnvsubst.subst((Node)x, (Function)envLookup));
                SparqlStmtUtils.process(conn, stmt2, null, new SPARQLResultSinkQuads(quadConsumer));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Model execConstruct(RDFConnection conn, String filenameOrURI) {
        Model result = ModelFactory.createDefaultModel();
        SparqlStmtMgr.readConnection(conn, filenameOrURI, q -> result.add(ModelUtils.tripleToStatement((Model)result, (Triple)q.asTriple())));
        return result;
    }

    public static Model execConstruct(Supplier<RDFConnection> dataSource, String filenameOrURI) {
        try (RDFConnection conn = dataSource.get();){
            Model model = SparqlStmtMgr.execConstruct(conn, filenameOrURI);
            return model;
        }
    }

    public static List<SparqlStmt> loadSparqlStmts(Path path) {
        return SparqlStmtMgr.loadSparqlStmts(path, (SparqlStmtParser)SparqlStmtParserImpl.create());
    }

    public static List<SparqlStmt> loadSparqlStmts(Path path, SparqlStmtParser parser) {
        ArrayList<SparqlStmt> result = new ArrayList<SparqlStmt>();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            SparqlStmtIterator it = SparqlStmtUtils.parse(in, parser);
            it.forEachRemaining(result::add);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static List<SparqlStmt> loadSparqlStmts(String filenameOrURI) {
        return SparqlStmtMgr.loadSparqlStmts(filenameOrURI, (SparqlStmtParser)SparqlStmtParserImpl.create(Syntax.syntaxARQ, true));
    }

    public static List<SparqlStmt> loadSparqlStmts(String filenameOrURI, PrefixMapping prefixes) {
        SparqlStmtParserImpl parser = SparqlStmtParserImpl.create(Syntax.syntaxARQ, prefixes, true);
        return SparqlStmtMgr.loadSparqlStmts(filenameOrURI, (SparqlStmtParser)parser);
    }

    public static List<SparqlStmt> loadSparqlStmts(String filenameOrURI, SparqlStmtParser parser) {
        List<SparqlStmt> result;
        try (TypedInputStream in = SparqlStmtUtils.openInputStream(filenameOrURI);){
            SparqlStmtIterator it;
            if (in == null) {
                throw new RuntimeException("Could not open input stream from " + filenameOrURI);
            }
            try {
                it = SparqlStmtUtils.parse((InputStream)in, parser);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            result = Streams.stream((Iterator)((Object)it)).collect(Collectors.toList());
        }
        return result;
    }

    public static Iterator<SparqlStmt> createIteratorSparqlStmts(String filenameOrStr, SparqlStmtParser sparqlParser) throws IOException {
        Object it = null;
        try {
            it = SparqlStmtUtils.readStmts(filenameOrStr, sparqlParser);
        }
        catch (IOException e) {
            block4: {
                try {
                    SparqlStmt sparqlStmt = (SparqlStmt)sparqlParser.apply(filenameOrStr);
                    it = Collections.singletonList(sparqlStmt).iterator();
                }
                catch (QueryParseException f) {
                    Throwable c = f.getCause();
                    if (SparqlStmtUtils.isEncounteredSlashException(c)) break block4;
                    throw new RuntimeException("Could not parse " + filenameOrStr, f);
                }
            }
            throw new IOException("Could not open " + filenameOrStr, e);
        }
        return it;
    }

    public static Function<String, Query> loadTemplate(String fileOrURI, String templateArgName) throws FileNotFoundException, IOException {
        Query templateQuery = SparqlStmtMgr.loadQuery(fileOrURI);
        Function<String, Query> result = value -> {
            Map<String, String> map = Collections.singletonMap(templateArgName, value);
            Query r = QueryUtils.applyNodeTransform((Query)templateQuery, x -> NodeEnvsubst.subst((Node)x, map::get));
            return r;
        };
        return result;
    }
}

