/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.parser.update;

import java.util.function.Supplier;
import org.aksw.jenax.stmt.core.SparqlParserConfig;
import org.aksw.jenax.stmt.parser.update.SparqlUpdateParser;
import org.aksw.jenax.stmt.parser.update.UpdateSupplierImpl;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class SparqlUpdateParserImpl
implements SparqlUpdateParser {
    protected Supplier<UpdateRequest> updateRequestSupplier;
    protected Syntax syntax;
    protected String baseURI;

    public SparqlUpdateParserImpl(Supplier<UpdateRequest> updateRequestSupplier, Syntax syntax, String baseURI) {
        this.updateRequestSupplier = updateRequestSupplier;
        this.syntax = syntax;
        this.baseURI = baseURI;
    }

    @Override
    public UpdateRequest apply(String updateString) {
        UpdateRequest result = this.updateRequestSupplier.get();
        UpdateFactory.parse((UpdateRequest)result, (String)updateString, (String)this.baseURI, (Syntax)this.syntax);
        return result;
    }

    public static SparqlUpdateParserImpl create(SparqlParserConfig config) {
        SparqlUpdateParserImpl result = SparqlUpdateParserImpl.create(config.getSyntax(), config.getPrologue(), config.getBaseURI(), config.getSharedPrefixes());
        return result;
    }

    public static SparqlUpdateParserImpl create() {
        SparqlUpdateParserImpl result = SparqlUpdateParserImpl.create(Syntax.syntaxARQ);
        return result;
    }

    public static SparqlUpdateParserImpl create(Syntax syntax) {
        Prologue prologue = new Prologue((PrefixMapping)new PrefixMappingImpl(), IRIxResolver.create().noBase().allowRelative(true).build());
        SparqlUpdateParserImpl result = SparqlUpdateParserImpl.create(syntax, prologue);
        return result;
    }

    public static SparqlUpdateParserImpl create(Syntax syntax, Prologue prologue) {
        return SparqlUpdateParserImpl.create(syntax, prologue, "", null);
    }

    public static SparqlUpdateParserImpl create(Syntax syntax, Prologue prologue, String baseURI, PrefixMapping sharedPrefixes) {
        UpdateSupplierImpl updateSupplier = new UpdateSupplierImpl(prologue, baseURI, sharedPrefixes);
        SparqlUpdateParserImpl result = new SparqlUpdateParserImpl(updateSupplier, syntax, null);
        return result;
    }

    public static SparqlUpdateParserImpl createAsGiven() {
        return SparqlUpdateParserImpl.create(SparqlParserConfig.newInstance().parseAsGiven().applyDefaults());
    }
}

