/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.util;

import com.google.common.collect.AbstractIterator;
import java.util.function.Function;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.util.QueryParseExceptionUtils;
import org.apache.jena.query.QueryParseException;

public class SparqlStmtIterator
extends AbstractIterator<SparqlStmt> {
    protected Function<String, SparqlStmt> parser;
    protected String str;
    protected int line = 1;
    protected int column = 1;

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public SparqlStmtIterator(Function<String, SparqlStmt> parser, String str) {
        this(parser, str, 1, 1);
    }

    public SparqlStmtIterator(Function<String, SparqlStmt> parser, String str, int line, int column) {
        this.parser = parser;
        this.str = str;
        this.line = line;
        this.column = column;
    }

    public static boolean isEmptyString(String str) {
        return str == null ? true : str.trim().isEmpty();
    }

    protected SparqlStmt computeNext() {
        int pos;
        if (SparqlStmtIterator.isEmptyString(this.str)) {
            return (SparqlStmt)this.endOfData();
        }
        SparqlStmt result = this.parser.apply(this.str);
        QueryParseException ex = result.getParseException();
        int[] exPos = ex == null ? null : QueryParseExceptionUtils.parseLineAndCol(ex);
        int n = pos = exPos == null ? -1 : StringUtils.findCharPos((String)this.str, (int)exPos[0], (int)exPos[1]);
        if (pos != -1) {
            String retryStr;
            this.line += Math.max(0, exPos[0] - 1);
            this.column += Math.max(0, exPos[1] - 1);
            try {
                retryStr = this.str.substring(0, pos);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw QueryParseExceptionUtils.copyAndAdjust(ex, this.line, this.column);
            }
            if (SparqlStmtIterator.isEmptyString(retryStr)) {
                throw QueryParseExceptionUtils.copyAndAdjust(ex, this.line, this.column);
            }
            result = this.parser.apply(retryStr);
            QueryParseException retryEx = result.getParseException();
            if (retryEx != null) {
                throw QueryParseExceptionUtils.copyAndAdjust(ex, this.line, this.column);
            }
            this.str = this.str.substring(pos);
        } else {
            this.str = "";
        }
        return result;
    }
}

