/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.util;

import com.google.common.collect.ComparisonChain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.query.QueryParseException;

public class QueryParseExceptionUtils {
    public static final Pattern posPattern = Pattern.compile("(line )(\\d+)(, column )(\\d+)", 2);

    public static int[] adjustLineAndCol(int[] in) {
        int[] result;
        if (in != null) {
            int x = in[0];
            int y = in[1];
            result = new int[]{x == 0 ? 1 : x, y == 0 ? 1 : y};
        } else {
            result = null;
        }
        return result;
    }

    public static int[] parseLineAndCol(String str) {
        int[] result;
        Matcher m = posPattern.matcher(str);
        if (m.find()) {
            int line = Integer.parseInt(m.group(2));
            int col = Integer.parseInt(m.group(4));
            result = new int[]{line, col};
        } else {
            result = null;
        }
        return result;
    }

    public static int[] parseLineAndCol(QueryParseException e) {
        int[] tmp = QueryParseExceptionUtils.parseRawLineAndCol(e);
        int[] result = QueryParseExceptionUtils.adjustLineAndCol(tmp);
        return result;
    }

    public static int[] parseRawLineAndCol(QueryParseException e) {
        String msg = e.getMessage();
        int[] result = QueryParseExceptionUtils.parseLineAndCol(msg);
        return result;
    }

    public static int[] lineAndCol(QueryParseException e) {
        int l = e.getLine();
        int c = e.getColumn();
        return new int[]{l == -1 ? Integer.MAX_VALUE : l, c == -1 ? Integer.MAX_VALUE : c};
    }

    public static QueryParseException copyAndAdjust(QueryParseException e, int line, int column) {
        String rawMsg = e.getMessage();
        Matcher m = posPattern.matcher(rawMsg);
        StringBuilder sb = new StringBuilder();
        if (m.find()) {
            m.appendReplacement(sb, "$1" + Integer.toString(line) + "$3" + Integer.toString(column));
        }
        m.appendTail(sb);
        String adjustedMsg = sb.toString();
        QueryParseException result = new QueryParseException(adjustedMsg, line, column);
        result.addSuppressed((Throwable)e);
        return result;
    }

    public static int doCompare(QueryParseException a, QueryParseException b) {
        int[] aa = QueryParseExceptionUtils.lineAndCol(a);
        int[] bb = QueryParseExceptionUtils.lineAndCol(b);
        int result = ComparisonChain.start().compare(bb[0], aa[0]).compare(bb[1], aa[1]).result();
        return result;
    }
}

