/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.parser.update;

import java.util.function.Function;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.parser.update.SparqlUpdateParser;
import org.apache.jena.update.UpdateRequest;

public class SparqlUpdateParserStmt
implements SparqlUpdateParser {
    protected Function<String, SparqlStmt> stmtParser;

    public SparqlUpdateParserStmt(Function<String, SparqlStmt> stmtParser) {
        this.stmtParser = stmtParser;
    }

    @Override
    public UpdateRequest apply(String queryStr) {
        SparqlStmt stmt = this.stmtParser.apply(queryStr);
        if (!stmt.isUpdateRequest()) {
            throw new RuntimeException("SPARQL statement is not an update request: " + String.valueOf(stmt));
        }
        UpdateRequest result = stmt.getAsUpdateStmt().getUpdateRequest();
        return result;
    }

    public static SparqlUpdateParserStmt wrap(Function<String, SparqlStmt> stmtParser) {
        SparqlUpdateParserStmt result = new SparqlUpdateParserStmt(stmtParser);
        return result;
    }
}

