/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.parser.query;

import java.util.function.Function;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParser;
import org.apache.jena.query.Query;

public class SparqlQueryParserStmt
implements SparqlQueryParser {
    protected Function<String, SparqlStmt> stmtParser;

    public SparqlQueryParserStmt(Function<String, SparqlStmt> stmtParser) {
        this.stmtParser = stmtParser;
    }

    @Override
    public Query apply(String queryStr) {
        SparqlStmt stmt = this.stmtParser.apply(queryStr);
        if (!stmt.isQuery()) {
            throw new RuntimeException("SPARQL statement is not a query: " + String.valueOf(stmt));
        }
        Query result = stmt.getAsQueryStmt().getQuery();
        return result;
    }

    public static SparqlQueryParserStmt wrap(Function<String, SparqlStmt> stmtParser) {
        SparqlQueryParserStmt result = new SparqlQueryParserStmt(stmtParser);
        return result;
    }
}

