/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.core;

import org.aksw.jenax.arq.util.irixresolver.IRIxResolverUtils;
import org.aksw.jenax.arq.util.prologue.PrologueUtils;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Prologue;

public class SparqlParserConfig
implements Cloneable {
    protected Syntax syntax;
    protected Prologue prologue;
    protected String baseURI;
    protected PrefixMapping sharedPrefixes;

    public SparqlParserConfig clone() {
        SparqlParserConfig result = new SparqlParserConfig(this.syntax, this.prologue.copy(), this.baseURI, this.sharedPrefixes);
        return result;
    }

    public SparqlParserConfig() {
        this(null);
    }

    public SparqlParserConfig(Syntax syntax) {
        this(syntax, null);
    }

    public SparqlParserConfig(Syntax syntax, Prologue prologue) {
        this(syntax, prologue, null);
    }

    public SparqlParserConfig(Syntax syntax, Prologue prologue, String baseURI) {
        this(syntax, prologue, baseURI, null);
    }

    public SparqlParserConfig(Syntax syntax, Prologue prologue, String baseURI, PrefixMapping sharedPrefixes) {
        this.syntax = syntax;
        this.prologue = prologue;
        this.baseURI = baseURI;
        this.sharedPrefixes = sharedPrefixes;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public SparqlParserConfig setSyntax(Syntax syntax) {
        this.syntax = syntax;
        return this;
    }

    public Prologue getPrologue() {
        return this.prologue;
    }

    public SparqlParserConfig setPrologue(Prologue prologue) {
        this.prologue = prologue;
        return this;
    }

    public SparqlParserConfig setSharedPrefixes(PrefixMapping sharedPrefixes) {
        this.sharedPrefixes = sharedPrefixes;
        return this;
    }

    public SparqlParserConfig setIrixResolver(IRIxResolver resolver) {
        if (this.prologue == null) {
            this.prologue = new Prologue((PrefixMapping)new PrefixMappingImpl(), resolver);
        } else {
            PrologueUtils.setResolver((Prologue)this.prologue, (IRIxResolver)resolver);
        }
        return this;
    }

    public SparqlParserConfig setPrefixMapping(PrefixMapping pm) {
        if (pm != null) {
            if (this.prologue == null) {
                this.prologue = new Prologue(pm, this.newDefaultIrixResolver());
            } else {
                this.prologue.setPrefixMapping(pm);
            }
        }
        return this;
    }

    public SparqlParserConfig parseAsGiven() {
        this.setIrixResolverAsGiven();
        this.setBaseURI("");
        return this;
    }

    public SparqlParserConfig setIrixResolverAsGiven() {
        return this.setIrixResolver(this.newDefaultIrixResolver());
    }

    protected IRIxResolver newDefaultIrixResolver() {
        return IRIxResolverUtils.newIRIxResolverAsGiven();
    }

    public PrefixMapping getPrefixMapping() {
        PrefixMapping result = this.prologue == null ? null : this.prologue.getPrefixMapping();
        return result;
    }

    public PrefixMapping getSharedPrefixes() {
        return this.sharedPrefixes;
    }

    public static SparqlParserConfig newInstance() {
        SparqlParserConfig result = new SparqlParserConfig();
        return result;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public SparqlParserConfig setBaseURI(String baseURI) {
        this.baseURI = baseURI;
        return this;
    }

    public SparqlParserConfig applyDefaults() {
        if (this.syntax == null) {
            this.syntax = Syntax.syntaxARQ;
        }
        if (this.prologue == null) {
            this.prologue = new Prologue(PrefixMapping.Extended);
        }
        if (this.prologue.getResolver() == null) {
            PrologueUtils.setResolver((Prologue)this.prologue, (IRIxResolver)this.newDefaultIrixResolver());
            this.baseURI = "";
        }
        return this;
    }
}

