/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.resultset;

import java.util.Iterator;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.SPARQLResult;

public class SPARQLResultEx
extends SPARQLResult
implements AutoCloseable {
    protected Iterator<Triple> triples;
    protected Iterator<Quad> quads;
    protected boolean updateType;
    protected Runnable closeAction = null;

    public SPARQLResultEx() {
    }

    public SPARQLResultEx(Model model) {
        super(model);
    }

    public SPARQLResultEx(ResultSet resultSet, Runnable closeAction) {
        super(resultSet);
        this.closeAction = closeAction;
    }

    public SPARQLResultEx(boolean booleanResult) {
        super(booleanResult);
    }

    public SPARQLResultEx(Dataset dataset) {
        super(dataset);
    }

    public SPARQLResultEx(Iterator<JsonObject> jsonItems, Runnable closeAction) {
        super(jsonItems);
        this.closeAction = closeAction;
    }

    public SPARQLResultEx(SPARQLResult that) {
        if (that.isBoolean()) {
            this.set(that.getBooleanResult());
        } else if (that.isDataset()) {
            this.set(that.getDataset());
        } else if (that.isJson()) {
            this.set(that.getJsonItems());
        } else if (that.isModel()) {
            this.set(that.getModel());
        } else if (that.isResultSet()) {
            this.set(that.getResultSet());
        } else {
            throw new IllegalArgumentException("Unknown SPARQLResult type");
        }
    }

    public boolean isTriples() {
        if (!this.isHasBeenSet()) {
            throw new ResultSetException("Not set");
        }
        return this.triples != null;
    }

    public Iterator<Triple> getTriples() {
        if (!this.isHasBeenSet()) {
            throw new ResultSetException("Not set");
        }
        if (!this.isTriples()) {
            throw new ResultSetException("Not a Triples result");
        }
        return this.triples;
    }

    public boolean isQuads() {
        if (!this.isHasBeenSet()) {
            throw new ResultSetException("Not set");
        }
        return this.quads != null;
    }

    public Iterator<Quad> getQuads() {
        if (!this.isHasBeenSet()) {
            throw new ResultSetException("Not set");
        }
        if (!this.isQuads()) {
            throw new ResultSetException("Not a Quads result");
        }
        return this.quads;
    }

    public boolean isUpdateType() {
        if (!this.isHasBeenSet()) {
            throw new ResultSetException("Not set");
        }
        return this.updateType;
    }

    public static SPARQLResult copy(SPARQLResult that) {
        SPARQLResult result = that.isBoolean() ? new SPARQLResult(that.getBooleanResult().booleanValue()) : (that.isDataset() ? new SPARQLResult(that.getDataset()) : (that.isJson() ? new SPARQLResult(that.getJsonItems()) : (that.isModel() ? new SPARQLResult(that.getModel()) : (that.isResultSet() ? new SPARQLResult(that.getResultSet()) : null))));
        return result;
    }

    protected void setTriples(Iterator<Triple> triples, Runnable closeAction) {
        this.triples = triples;
        this.closeAction = closeAction;
        this.set(null);
    }

    protected void setQuads(Iterator<Quad> quads, Runnable closeAction) {
        this.quads = quads;
        this.closeAction = closeAction;
        this.set(null);
    }

    protected void setUpdateType() {
        this.updateType = true;
        this.set(null);
    }

    public static SPARQLResultEx createTriples(Iterator<Triple> triples, Runnable closeAction) {
        SPARQLResultEx result = new SPARQLResultEx();
        result.setTriples(triples, closeAction);
        return result;
    }

    public static SPARQLResultEx createQuads(Iterator<Quad> quads, Runnable closeAction) {
        SPARQLResultEx result = new SPARQLResultEx();
        result.setQuads(quads, closeAction);
        return result;
    }

    public static SPARQLResultEx createUpdateType() {
        SPARQLResultEx result = new SPARQLResultEx();
        result.setUpdateType();
        return result;
    }

    @Override
    public void close() {
        if (this.closeAction != null) {
            this.closeAction.run();
        }
    }
}

