/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.parser.query;

import java.util.function.Function;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParser;
import org.aksw.jenax.stmt.util.QueryParseExceptionUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;

public class SparqlQueryParserWrapperSelectShortForm
implements SparqlQueryParser {
    protected Function<String, Query> delegate;

    public SparqlQueryParserWrapperSelectShortForm(Function<String, Query> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Query apply(String str) {
        Query result;
        block6: {
            result = null;
            try {
                result = this.delegate.apply(str);
            }
            catch (QueryParseException e) {
                int col;
                int line;
                int charPos;
                int[] lineAndCol = QueryParseExceptionUtils.parseLineAndCol(e);
                if (lineAndCol != null && (charPos = StringUtils.findCharPos((String)str, (int)(line = lineAndCol[0]), (int)(col = lineAndCol[1]))) != -1) {
                    String inject = " SELECT ";
                    String newStr = str.substring(0, charPos) + inject + str.substring(charPos);
                    try {
                        result = this.delegate.apply(newStr);
                    }
                    catch (QueryParseException f) {
                        int[] lineAndCol2 = QueryParseExceptionUtils.parseLineAndCol(f);
                        if (lineAndCol2 != null) {
                            int line2 = lineAndCol2[0];
                            int col2 = lineAndCol2[1];
                            int effectiveCol = line == line2 && col2 >= col + inject.length() ? col2 - inject.length() : col2;
                            throw new QueryParseException(e.getMessage(), (Throwable)e, line, effectiveCol);
                        }
                        throw new QueryParseException(f.getMessage(), (Throwable)f, f.getLine(), f.getColumn());
                    }
                }
                if (result != null) break block6;
                throw new QueryParseException(e.getMessage(), (Throwable)e, e.getLine(), e.getColumn());
            }
        }
        return result;
    }

    public static SparqlQueryParserWrapperSelectShortForm wrap(Function<String, Query> delegate) {
        SparqlQueryParserWrapperSelectShortForm result = new SparqlQueryParserWrapperSelectShortForm(delegate);
        return result;
    }
}

