/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.core;

import org.aksw.jenax.stmt.core.SparqlParserConfig;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtBase;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.aksw.jenax.stmt.core.SparqlStmtUnknown;
import org.aksw.jenax.stmt.core.SparqlStmtUpdate;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParser;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserImpl;
import org.aksw.jenax.stmt.parser.update.SparqlUpdateParser;
import org.aksw.jenax.stmt.parser.update.SparqlUpdateParserImpl;
import org.aksw.jenax.stmt.util.QueryParseExceptionUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.update.UpdateRequest;

public class SparqlStmtParserImpl
implements SparqlStmtParser {
    protected SparqlQueryParser queryParser;
    protected SparqlUpdateParser updateParser;
    protected String parserBase;
    protected boolean actAsClassifier;

    public SparqlStmtParserImpl(SparqlQueryParser queryParser, SparqlUpdateParser updateParser) {
        this(queryParser, updateParser, null, false);
    }

    public SparqlStmtParserImpl(SparqlQueryParser queryParser, SparqlUpdateParser updateParser, String parserBase, boolean actAsClassifier) {
        this.queryParser = queryParser;
        this.updateParser = updateParser;
        this.parserBase = parserBase;
        this.actAsClassifier = actAsClassifier;
    }

    public SparqlQueryParser getQueryParser() {
        return this.queryParser;
    }

    public SparqlUpdateParser getUpdateParser() {
        return this.updateParser;
    }

    public boolean isActAsClassifier() {
        return this.actAsClassifier;
    }

    @Override
    public SparqlStmt apply(String stmtStr) {
        SparqlStmtBase result;
        block11: {
            try {
                Query query = (Query)this.queryParser.apply(stmtStr);
                result = new SparqlStmtQuery(query, this.parserBase);
            }
            catch (QueryParseException queryException) {
                try {
                    UpdateRequest updateRequest = (UpdateRequest)this.updateParser.apply(stmtStr);
                    result = new SparqlStmtUpdate(updateRequest);
                }
                catch (QueryParseException updateException) {
                    boolean isQueryException;
                    int delta = QueryParseExceptionUtils.doCompare(queryException, updateException);
                    boolean bl = isQueryException = delta <= 0;
                    if (isQueryException) {
                        if (this.actAsClassifier) {
                            result = new SparqlStmtQuery(null, stmtStr, this.parserBase, queryException);
                            break block11;
                        }
                        throw new QueryParseException("Failed to parse " + stmtStr, (Throwable)queryException, queryException.getLine(), queryException.getColumn());
                    }
                    if (this.actAsClassifier) {
                        result = new SparqlStmtUpdate(null, stmtStr, this.parserBase, updateException);
                        break block11;
                    }
                    throw new QueryParseException("Failed to parse " + stmtStr, (Throwable)updateException, updateException.getLine(), updateException.getColumn());
                }
                catch (Exception e) {
                    if (this.actAsClassifier) {
                        result = new SparqlStmtUnknown(stmtStr, this.parserBase, new QueryParseException((Throwable)e, 1, 1));
                        break block11;
                    }
                    throw new QueryParseException("Failed to parse " + stmtStr, (Throwable)e, 1, 1);
                }
            }
            catch (Exception e) {
                if (this.actAsClassifier) {
                    result = new SparqlStmtUnknown(stmtStr, this.parserBase, new QueryParseException((Throwable)e, 1, 1));
                }
                throw new QueryParseException("Failed to parse " + stmtStr, (Throwable)e, 1, 1);
            }
        }
        return result;
    }

    public static SparqlStmtParserImpl create() {
        SparqlStmtParserImpl result = SparqlStmtParserImpl.create(Syntax.syntaxARQ, false);
        return result;
    }

    public static SparqlStmtParserImpl create(PrefixMapping prefixMapping) {
        SparqlStmtParserImpl result = SparqlStmtParserImpl.create(Syntax.syntaxARQ, prefixMapping, false);
        return result;
    }

    public static SparqlStmtParserImpl create(Syntax syntax, boolean actAsClassifier) {
        SparqlStmtParserImpl result = SparqlStmtParserImpl.create(SparqlParserConfig.newInstance().setSyntax(syntax).applyDefaults(), actAsClassifier);
        return result;
    }

    public static SparqlStmtParserImpl create(Syntax syntax, PrefixMapping prefixMapping, boolean actAsClassifier) {
        SparqlStmtParserImpl result = SparqlStmtParserImpl.create(SparqlParserConfig.newInstance().setSyntax(syntax).setPrefixMapping(prefixMapping).applyDefaults(), actAsClassifier);
        return result;
    }

    public static SparqlStmtParserImpl create(Syntax syntax, PrefixMapping prefixMapping, PrefixMapping sharedPrefixes, boolean actAsClassifier) {
        SparqlStmtParserImpl result = SparqlStmtParserImpl.create(SparqlParserConfig.newInstance().setSyntax(syntax).setPrefixMapping(prefixMapping).setSharedPrefixes(sharedPrefixes).applyDefaults(), actAsClassifier);
        return result;
    }

    public static SparqlStmtParserImpl create(Syntax syntax, Prologue prologue, boolean actAsClassifier) {
        SparqlStmtParserImpl result = SparqlStmtParserImpl.create(SparqlParserConfig.newInstance().setSyntax(syntax).setPrologue(prologue).applyDefaults(), actAsClassifier);
        return result;
    }

    public static SparqlStmtParserImpl create(SparqlParserConfig config) {
        SparqlStmtParserImpl result = SparqlStmtParserImpl.create(config, false);
        return result;
    }

    public static SparqlStmtParserImpl create(SparqlParserConfig config, boolean actAsClassifier) {
        SparqlQueryParserImpl queryParser = SparqlQueryParserImpl.create(config);
        SparqlUpdateParserImpl updateParser = SparqlUpdateParserImpl.create(config);
        SparqlStmtParserImpl result = new SparqlStmtParserImpl(queryParser, updateParser, config.getBaseURI(), actAsClassifier);
        return result;
    }

    public static SparqlStmtParserImpl createAsGiven() {
        return SparqlStmtParserImpl.create(SparqlParserConfig.newInstance().parseAsGiven().applyDefaults());
    }

    public static SparqlStmtParserImpl createAsGiven(boolean actAsClassifier) {
        return SparqlStmtParserImpl.create(SparqlParserConfig.newInstance().parseAsGiven().applyDefaults(), actAsClassifier);
    }
}

