/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.util;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.exception.HttpExceptionUtils;
import org.aksw.jenax.arq.util.node.NodeEnvsubst;
import org.aksw.jenax.arq.util.node.NodeTransformCollectNodes;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.syntax.ElementTransformSubst2;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.update.UpdateRequestUtils;
import org.aksw.jenax.arq.util.update.UpdateUtils;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.aksw.jenax.stmt.core.SparqlStmtUpdate;
import org.aksw.jenax.stmt.resultset.SPARQLResultEx;
import org.aksw.jenax.stmt.resultset.SPARQLResultVisitor;
import org.aksw.jenax.stmt.util.SparqlStmtIterator;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.http.HttpOp;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.lang.arq.ParseException;
import org.apache.jena.sparql.modify.request.UpdateData;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.sparql.syntax.syntaxtransform.UpdateTransformOps;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecution;
import org.apache.jena.update.UpdateRequest;

public class SparqlStmtUtils {
    public static final Symbol symConnection = Symbol.create((String)"http://jsa.aksw.org/connection");

    public static Set<Node> mentionedNodes(SparqlStmt stmt) {
        NodeTransformCollectNodes xform = new NodeTransformCollectNodes();
        SparqlStmtUtils.applyNodeTransform(stmt, (NodeTransform)xform);
        Set result = xform.getNodes();
        return result;
    }

    public static Map<String, Boolean> mentionedEnvVars(SparqlStmt stmt) {
        NodeTransformCollectNodes xform = new NodeTransformCollectNodes();
        SparqlStmtUtils.applyNodeTransform(stmt, (NodeTransform)xform);
        Set nodes = xform.getNodes();
        Map<String, Boolean> result = nodes.stream().map(NodeEnvsubst::getEnvKey).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return result;
    }

    public static boolean isEncounteredSlashException(Throwable t) {
        boolean result = false;
        if (t instanceof QueryParseException) {
            QueryParseException qpe = (QueryParseException)t;
            result = Optional.ofNullable(qpe.getMessage()).orElse("").contains("Encountered: \"/\"");
        }
        return result;
    }

    public static List<Var> getUnionProjectVars(Collection<? extends SparqlStmt> stmts) {
        List selectQueries = stmts.stream().filter(SparqlStmt::isQuery).map(SparqlStmt::getQuery).filter(Query::isSelectType).collect(Collectors.toList());
        LinkedHashSet result = new LinkedHashSet();
        for (Query query : selectQueries) {
            List varContrib = query.getProjectVars();
            result.addAll(varContrib);
        }
        return new ArrayList<Var>(result);
    }

    public static SparqlStmt optimizePrefixes(SparqlStmt stmt) {
        SparqlStmtUtils.optimizePrefixes(stmt, null);
        return stmt;
    }

    public static SparqlStmt optimizePrefixes(SparqlStmt stmt, PrefixMapping globalPm) {
        if (stmt.isParsed()) {
            if (stmt.isQuery()) {
                QueryUtils.optimizePrefixes((Query)stmt.getQuery(), (PrefixMapping)globalPm);
            } else if (stmt.isUpdateRequest()) {
                UpdateRequestUtils.optimizePrefixes((UpdateRequest)stmt.getUpdateRequest(), (PrefixMapping)globalPm);
            }
        }
        return stmt;
    }

    public static SparqlStmt applyElementTransform(SparqlStmt stmt, Function<? super Element, ? extends Element> transform) {
        SparqlStmt result;
        if (stmt.isQuery()) {
            Query tmp = stmt.getAsQueryStmt().getQuery();
            Query query = QueryUtils.applyElementTransform((Query)tmp, transform);
            result = new SparqlStmtQuery(query);
        } else if (stmt.isUpdateRequest()) {
            UpdateRequest tmp = stmt.getAsUpdateStmt().getUpdateRequest();
            UpdateRequest updateRequest = UpdateRequestUtils.applyTransformElt((UpdateRequest)tmp, transform);
            result = new SparqlStmtUpdate(updateRequest);
        } else {
            result = stmt;
        }
        return result;
    }

    public static SparqlStmt applyOpTransform(SparqlStmt stmt, Transform transform) {
        return SparqlStmtUtils.applyOpTransform(stmt, (? super Op op) -> Transformer.transform((Transform)transform, (Op)op));
    }

    public static SparqlStmt applyOpTransform(SparqlStmt stmt, Function<? super Op, ? extends Op> transform) {
        SparqlStmt result;
        if (stmt.isQuery()) {
            Query tmp = stmt.getAsQueryStmt().getQuery();
            Query query = QueryUtils.applyOpTransform((Query)tmp, transform);
            result = new SparqlStmtQuery(query);
        } else if (stmt.isUpdateRequest()) {
            UpdateRequest tmp = stmt.getAsUpdateStmt().getUpdateRequest();
            UpdateRequest updateRequest = UpdateRequestUtils.applyOpTransform((UpdateRequest)tmp, transform);
            result = new SparqlStmtUpdate(updateRequest);
        } else {
            result = stmt;
        }
        return result;
    }

    public static SparqlStmt applyNodeTransform(SparqlStmt stmt, NodeTransform xform) {
        SparqlStmt result;
        ElementTransformSubst2 elform = new ElementTransformSubst2(xform);
        ExprTransformNodeElement exform = new ExprTransformNodeElement(xform, (ElementTransform)elform);
        if (stmt.isQuery()) {
            Query before = stmt.getAsQueryStmt().getQuery();
            Query after = QueryUtils.applyNodeTransform((Query)before, (NodeTransform)xform);
            result = new SparqlStmtQuery(after);
        } else if (stmt.isUpdateRequest()) {
            UpdateRequest before = stmt.getAsUpdateStmt().getUpdateRequest();
            UpdateRequest after = UpdateRequestUtils.copyTransform((UpdateRequest)before, arg_0 -> SparqlStmtUtils.lambda$applyNodeTransform$2(xform, (ElementTransform)elform, (ExprTransform)exform, arg_0));
            result = new SparqlStmtUpdate(after);
        } else {
            result = stmt;
        }
        return result;
    }

    public static SparqlStmtIterator processFile(PrefixMapping pm, String filenameOrURI) throws FileNotFoundException, IOException, ParseException {
        return SparqlStmtUtils.processFile(pm, filenameOrURI, null);
    }

    public static URI extractBaseIri(String filenameOrURI) {
        URI uri;
        Context context = null;
        StreamManager streamManager = StreamManager.get(context);
        String urlStr = streamManager.mapURI(filenameOrURI);
        try {
            uri = new URI(urlStr);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        URI parent = uri.getPath().endsWith("/") ? uri.resolve("..") : uri.resolve(".");
        return parent;
    }

    public static String loadString(String filenameOrURI) throws IOException {
        String result;
        try (TypedInputStream in = SparqlStmtUtils.openInputStream(filenameOrURI);){
            result = in != null ? CharStreams.toString((Readable)new InputStreamReader((InputStream)in, Charsets.UTF_8)) : null;
        }
        return result;
    }

    public static TypedInputStream openInputStream(String filenameOrURI) {
        TypedInputStream in;
        Context context = null;
        StreamManager streamManager = StreamManager.get(context);
        String urlStr = streamManager.mapURI(filenameOrURI);
        urlStr = StreamManager.get(context).mapURI(urlStr);
        if (urlStr.startsWith("http://") || urlStr.startsWith("https://")) {
            Object httpClient = null;
            String acceptHeader = httpClient == null ? "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.7,application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.5" : null;
            in = HttpOp.httpGet((String)urlStr, (String)acceptHeader);
        } else {
            in = streamManager.open(urlStr);
        }
        return in;
    }

    public static SparqlStmtIterator readStmts(String filenameOrURI, SparqlStmtParser parser) throws IOException {
        TypedInputStream in = SparqlStmtUtils.openInputStream(filenameOrURI);
        if (in == null) {
            throw new IOException("Could not open input stream from " + filenameOrURI);
        }
        SparqlStmtIterator result = SparqlStmtUtils.parse((InputStream)in, parser);
        return result;
    }

    public static SparqlStmtIterator processFile(PrefixMapping pm, String filenameOrURI, String baseIri) throws FileNotFoundException, IOException, ParseException {
        TypedInputStream in = SparqlStmtUtils.openInputStream(filenameOrURI);
        if (in == null) {
            throw new IOException("Could not open input stream from " + filenameOrURI);
        }
        if (baseIri == null) {
            URI tmp = SparqlStmtUtils.extractBaseIri(filenameOrURI);
            baseIri = tmp.toString();
        }
        return SparqlStmtUtils.processInputStream(pm, baseIri, (InputStream)in);
    }

    @Deprecated
    public static SparqlStmtIterator processInputStream(PrefixMapping pm, String baseIri, InputStream in) throws IOException, ParseException {
        Prologue prologue = new Prologue();
        prologue.setPrefixMapping(pm);
        prologue.setBaseURI(baseIri);
        SparqlStmtParserImpl rawSparqlStmtParser = SparqlStmtParserImpl.create(Syntax.syntaxARQ, prologue, true);
        SparqlStmtParser sparqlStmtParser = SparqlStmtParser.wrapWithNamespaceTracking(pm, rawSparqlStmtParser);
        SparqlStmtIterator stmts = SparqlStmtUtils.parse(in, sparqlStmtParser);
        return stmts;
    }

    public static SparqlStmtIterator parse(InputStream in, Function<String, SparqlStmt> parser) throws IOException {
        String str;
        try {
            str = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        finally {
            in.close();
        }
        SparqlStmtIterator result = new SparqlStmtIterator(parser, str);
        return result;
    }

    public static SPARQLResultEx execAny(QueryExecution qe, Query q) {
        SPARQLResultEx result;
        if (q == null) {
            q = qe.getQuery();
        }
        if (q.isConstructQuad()) {
            Iterator it = qe.execConstructQuads();
            result = SPARQLResultEx.createQuads(it, () -> ((QueryExecution)qe).close());
        } else if (q.isConstructType()) {
            Iterator it = qe.execConstructTriples();
            result = SPARQLResultEx.createTriples(it, () -> ((QueryExecution)qe).close());
        } else if (q.isSelectType()) {
            ResultSet rs = qe.execSelect();
            result = new SPARQLResultEx(rs, () -> ((QueryExecution)qe).close());
        } else if (q.isJsonType()) {
            Iterator it = qe.execJsonItems();
            result = new SPARQLResultEx(it, () -> ((QueryExecution)qe).close());
        } else if (q.isAskType()) {
            boolean v = qe.execAsk();
            result = new SPARQLResultEx(v);
        } else if (q.isDescribeType()) {
            Iterator it = qe.execDescribeTriples();
            result = SPARQLResultEx.createTriples(it, () -> ((QueryExecution)qe).close());
        } else {
            throw new RuntimeException("Unsupported query type");
        }
        return result;
    }

    public static SPARQLResultEx execAny(RDFConnection conn, SparqlStmt stmt, Consumer<Context> cxtMutator) {
        SPARQLResultEx result = null;
        if (stmt.isQuery()) {
            QueryExecution qe;
            Context cxt;
            SparqlStmtQuery qs = stmt.getAsQueryStmt();
            Query q = qs.getQuery();
            if (q == null) {
                String queryStr = qs.getOriginalString();
                q = QueryFactory.create((String)queryStr, (Syntax)Syntax.syntaxARQ);
            }
            if ((cxt = (qe = conn.query(q)).getContext()) != null) {
                if (cxtMutator != null) {
                    cxtMutator.accept(cxt);
                }
                cxt.set(symConnection, (Object)conn);
            }
            result = SparqlStmtUtils.execAny(qe, q);
        } else if (stmt.isUpdateRequest()) {
            Context cxt;
            UpdateRequest u = stmt.getAsUpdateStmt().getUpdateRequest();
            UpdateExecution ue = conn.newUpdate().update(u).build();
            if (cxtMutator != null && (cxt = ue.getContext()) != null) {
                cxtMutator.accept(cxt);
            }
            ue.execute();
            result = SPARQLResultEx.createUpdateType();
        }
        return result;
    }

    public static void overwriteDatasetDescription(SparqlStmt stmt, DatasetDescription dd) {
        if (stmt.isParsed()) {
            if (stmt.isQuery()) {
                QueryUtils.overwriteDatasetDescription((Query)stmt.getQuery(), (DatasetDescription)dd);
            } else if (stmt.isUpdateRequest()) {
                UpdateRequestUtils.overwriteDatasetDescription((UpdateRequest)stmt.getUpdateRequest(), (DatasetDescription)dd);
            }
        } else {
            throw new IllegalArgumentException("Cannot apply dataset description to a SPARQL query that has not been parsed.");
        }
    }

    public static void output(SPARQLResultEx rr, SPARQLResultVisitor sink) {
        try (SPARQLResultEx r = rr;){
            SPARQLResultVisitor.forward(r, sink);
        }
        catch (Exception e) {
            throw HttpExceptionUtils.makeHumanFriendly((Exception)e);
        }
    }

    public static void process(RDFConnection conn, SparqlStmt stmt, Consumer<Context> cxtMutator, SPARQLResultVisitor sink) {
        SPARQLResultEx sr = SparqlStmtUtils.execAny(conn, stmt, cxtMutator);
        SparqlStmtUtils.output(sr, sink);
    }

    public static Op toAlgebra(SparqlStmt stmt) {
        Op result = null;
        if (stmt.isQuery()) {
            Query q = stmt.getAsQueryStmt().getQuery();
            result = Algebra.compile((Query)q);
        } else if (stmt.isUpdateRequest()) {
            UpdateRequest ur = stmt.getAsUpdateStmt().getUpdateRequest();
            for (Update u : ur) {
                if (!(u instanceof UpdateModify)) continue;
                Element e = ((UpdateModify)u).getWherePattern();
                result = Algebra.compile((Element)e);
            }
        }
        return result;
    }

    public static Set<String> getMentionedEnvVars(Collection<? extends SparqlStmt> sparqlStmts) {
        NodeTransformCollectNodes collector = new NodeTransformCollectNodes();
        for (SparqlStmt sparqlStmt : sparqlStmts) {
            SparqlStmtUtils.applyNodeTransform(sparqlStmt, (NodeTransform)collector);
        }
        Set<String> usedEnvVarNames = collector.getNodes().stream().map(NodeEnvsubst::getEnvKey).filter(Objects::nonNull).map(Map.Entry::getKey).distinct().collect(Collectors.toSet());
        return usedEnvVarNames;
    }

    private static /* synthetic */ Update lambda$applyNodeTransform$2(NodeTransform xform, ElementTransform elform, ExprTransform exform, Update update) {
        Update r = update instanceof UpdateData ? UpdateUtils.copyWithQuadTransform((UpdateData)((UpdateData)update), q -> QuadUtils.applyNodeTransform((Quad)q, (NodeTransform)xform)) : UpdateTransformOps.transform((Update)update, (ElementTransform)elform, (ExprTransform)exform);
        return r;
    }
}

