/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.stmt.core;

import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.aksw.jenax.stmt.core.SparqlStmtUpdate;
import org.apache.jena.query.QueryParseException;

public abstract class SparqlStmtBase
implements SparqlStmt {
    private static final long serialVersionUID = 1L;
    protected String parserBase;
    protected String originalString;
    protected QueryParseException parseException;

    SparqlStmtBase() {
    }

    public SparqlStmtBase(String originalString) {
        this(originalString, null);
    }

    public SparqlStmtBase(String originalString, String parserBase) {
        this(originalString, parserBase, null);
    }

    public SparqlStmtBase(String originalString, String parserBase, QueryParseException parseException) {
        this.originalString = originalString;
        this.parserBase = parserBase;
        this.parseException = parseException;
    }

    @Override
    public abstract SparqlStmt clone();

    @Override
    public String getOriginalString() {
        return this.originalString;
    }

    @Override
    public QueryParseException getParseException() {
        return this.parseException;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    @Override
    public boolean isUpdateRequest() {
        return false;
    }

    @Override
    public SparqlStmtUpdate getAsUpdateStmt() {
        throw new RuntimeException("Invalid type");
    }

    @Override
    public SparqlStmtQuery getAsQueryStmt() {
        throw new RuntimeException("Invalid type");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originalString == null ? 0 : this.originalString.hashCode());
        result = 31 * result + (this.parseException == null ? 0 : this.parseException.hashCode());
        result = 31 * result + (this.parserBase == null ? 0 : this.parserBase.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparqlStmtBase other = (SparqlStmtBase)obj;
        if (this.originalString == null ? other.originalString != null : !this.originalString.equals(other.originalString)) {
            return false;
        }
        if (this.parseException == null ? other.parseException != null : !this.parseException.equals(other.parseException)) {
            return false;
        }
        return !(this.parserBase == null ? other.parserBase != null : !this.parserBase.equals(other.parserBase));
    }

    public String toString() {
        String result = this.parseException == null ? this.originalString : "SparqlStmtBase [originalString=" + this.originalString + ", parserBase=" + this.parserBase + ", parseException=" + String.valueOf(this.parseException) + "]";
        return result;
    }
}

