/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.sameas.assembler;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import org.aksw.jenax.arq.dataset.cache.CachePatterns;
import org.aksw.jenax.arq.dataset.cache.DatasetGraphCache;
import org.aksw.jenax.arq.sameas.model.SameAsConfig;
import org.aksw.jenax.arq.util.dataset.DatasetGraphSameAs;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.vocabulary.OWL2;

public class DatasetAssemblerSameAs
extends DatasetAssembler {
    public DatasetGraph createDataset(Assembler a, Resource root) {
        DatasetGraph result;
        SameAsConfig res = (SameAsConfig)root.as(SameAsConfig.class);
        Resource baseDatasetRes = res.getBaseDataset();
        Objects.requireNonNull(baseDatasetRes, "No ja:baseDataset specified on " + String.valueOf(root));
        Object obj = a.open(baseDatasetRes);
        int cacheMaxSize = Optional.ofNullable(res.getCacheSize()).orElse(0);
        boolean allowDuplicates = Optional.ofNullable(res.getAllowDuplicates()).orElse(false);
        LinkedHashSet<Node> predicates = new LinkedHashSet<Node>(res.getPredicates());
        if (predicates.isEmpty()) {
            predicates.add(OWL2.sameAs.asNode());
        }
        if (obj instanceof Dataset) {
            Dataset baseDataset = (Dataset)obj;
            DatasetGraph base = baseDataset.asDatasetGraph();
            if (cacheMaxSize > 0) {
                DatasetGraphCache cache = DatasetGraphCache.cache((DatasetGraph)base, (Collection)CachePatterns.forNeigborsByPredicates(predicates), (int)cacheMaxSize);
                result = DatasetGraphSameAs.wrap((DatasetGraph)cache, predicates, (boolean)allowDuplicates);
            } else {
                result = cacheMaxSize < 0 ? DatasetGraphSameAs.wrapWithTable((DatasetGraph)base, predicates, (boolean)allowDuplicates) : DatasetGraphSameAs.wrap((DatasetGraph)base, predicates, (boolean)allowDuplicates);
            }
        } else {
            Class<?> cls = obj == null ? null : obj.getClass();
            throw new AssemblerException(root, "Expected ja:baseDataset to be a Dataset but instead got " + Objects.toString(cls));
        }
        return result;
    }
}

