/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.sameas.dataset;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.util.cache.CacheUtils;
import org.aksw.jenax.arq.util.dataset.DatasetGraphWrapperFindBase;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapperView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.NodeCmp;
import org.apache.jena.vocabulary.OWL;

@Deprecated
public class DatasetGraphSameAsOld
extends DatasetGraphWrapperFindBase
implements DatasetGraphWrapperView {
    protected boolean logCacheStats = false;
    protected boolean allowDuplicates;
    protected Set<Node> sameAsPredicates;

    public static DatasetGraph wrap(DatasetGraph base) {
        return DatasetGraphSameAsOld.wrap(base, OWL.sameAs.asNode());
    }

    public static DatasetGraph wrap(DatasetGraph base, Node sameAsPredicate) {
        return new DatasetGraphSameAsOld(base, Collections.singleton(sameAsPredicate), false);
    }

    public static DatasetGraph wrap(DatasetGraph base, Set<Node> sameAsPredicates) {
        return new DatasetGraphSameAsOld(base, sameAsPredicates, false);
    }

    public static DatasetGraph wrap(DatasetGraph base, Set<Node> sameAsPredicates, boolean allowDuplicates) {
        return new DatasetGraphSameAsOld(base, sameAsPredicates, allowDuplicates);
    }

    protected DatasetGraphSameAsOld(DatasetGraph base, Set<Node> sameAsPredicates, boolean allowDuplicates) {
        super(base);
        this.sameAsPredicates = sameAsPredicates;
        this.allowDuplicates = allowDuplicates;
    }

    protected Iterator<Quad> actionFind(boolean ng, Node mg, Node ms, Node mp, Node mo) {
        Cache sameAsCache = CacheUtils.recordStats((CacheBuilder)CacheBuilder.newBuilder(), (boolean)this.logCacheStats).concurrencyLevel(1).maximumSize(10L).build();
        Cache leastInferredToPhysicalQuadCache = null;
        List<Node> initialSubjects = this.resolveSameAsSortedCached(mg, ms, (Cache<Map.Entry<Node, Node>, List<Node>>)sameAsCache);
        List<Node> initialObjects = this.resolveSameAsSortedCached(mg, mo, (Cache<Map.Entry<Node, Node>, List<Node>>)sameAsCache);
        Iter result = Iter.iter(initialSubjects).flatMap(s -> Iter.iter((Collection)initialObjects).flatMap(o -> Iter.iter((Iterator)this.delegateFind(ng, mg, (Node)s, mp, (Node)o)).flatMap(t -> this.streamInferencesOnLeastQuad((Quad)t, ms, mo, (Cache<Map.Entry<Node, Node>, List<Node>>)sameAsCache, (Cache<Quad, Quad>)leastInferredToPhysicalQuadCache))));
        if (this.logCacheStats) {
            result = Iter.onClose((Iterator)result, () -> {
                System.out.println("SameAsCache: " + String.valueOf(CacheUtils.stats((Cache)sameAsCache)));
                System.out.println("LeastQuadCache: " + String.valueOf(CacheUtils.stats((Cache)leastInferredToPhysicalQuadCache)));
            });
        }
        return result;
    }

    private Iterator<Quad> streamInferencesOnLeastQuad(Quad quad, Node ms, Node mo, Cache<Map.Entry<Node, Node>, List<Node>> sameAsCache, Cache<Quad, Quad> leastQuadCache) {
        Iter result;
        Node g = quad.getGraph();
        Node p = quad.getPredicate();
        List<Node> sortedSubjects = this.resolveSameAsSortedCached(g, quad.getSubject(), sameAsCache);
        List<Node> sortedObjects = this.resolveSameAsSortedCached(g, quad.getObject(), sameAsCache);
        if (sortedSubjects.size() == 1 && sortedObjects.size() == 1) {
            result = Iter.of((Object)quad);
        } else {
            boolean isLeastQuad;
            Node leastS = sortedSubjects.get(0);
            Node leastO = sortedObjects.get(0);
            Quad leastInferrableQuad = Quad.create((Node)g, (Node)leastS, (Node)p, (Node)leastO);
            if (!this.allowDuplicates) {
                Quad leastPhysicalQuad = (Quad)CacheUtils.get(leastQuadCache, (Object)leastInferrableQuad, () -> this.computeLeastPhysicalQuad(leastInferrableQuad, sortedSubjects, sortedObjects));
                isLeastQuad = quad.equals((Object)leastPhysicalQuad);
            } else {
                isLeastQuad = true;
            }
            List<Node> ss = ms.isConcrete() ? Collections.singletonList(ms) : sortedSubjects;
            List<Node> oo = mo.isConcrete() ? Collections.singletonList(mo) : sortedObjects;
            result = isLeastQuad ? Iter.iter(ss).flatMap(s -> Iter.iter((Collection)oo).map(o -> Quad.create((Node)g, (Node)s, (Node)p, (Node)o))) : Iter.empty();
        }
        return result;
    }

    private Quad computeLeastPhysicalQuad(Quad quad, List<Node> sortedSubjects, List<Node> sortedObjects) {
        Quad result = null;
        Node g = quad.getGraph();
        Node p = quad.getPredicate();
        block0: for (Node s : sortedSubjects) {
            for (Node o : sortedObjects) {
                if (!this.getR().contains(g, s, p, o)) continue;
                result = Quad.create((Node)g, (Node)s, (Node)p, (Node)o);
                break block0;
            }
        }
        if (result == null) {
            throw new IllegalStateException("Tuple [" + String.valueOf(quad) + "] was unexpectedly reported to not be contained in the backend");
        }
        return result;
    }

    private List<Node> resolveSameAsSortedCached(Node g, Node start, Cache<Map.Entry<Node, Node>, List<Node>> sameAsCache) {
        List result;
        if (!g.isConcrete() || !start.isConcrete() || start.isLiteral()) {
            result = Collections.singletonList(start);
        } else {
            boolean[] wasComputed = new boolean[]{false};
            Map.Entry<Node, Node> startKey = Map.entry(g, start);
            result = (List)CacheUtils.get(sameAsCache, startKey, () -> {
                wasComputed[0] = true;
                return this.resolveSameAsSorted(g, start);
            });
            boolean cacheClosureForAllMembers = false;
            if (cacheClosureForAllMembers && wasComputed[0]) {
                for (Node node : result) {
                    if (node.equals((Object)start)) continue;
                    sameAsCache.put(Map.entry(g, node), (Object)result);
                }
                sameAsCache.put(startKey, (Object)result);
            }
        }
        return result;
    }

    private List<Node> resolveSameAsSorted(Node g, Node start) {
        List result = (List)this.resolveSameAs(g, start).collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(result, NodeCmp::compareRDFTerms);
        return result;
    }

    private Iter<Node> resolveSameAs(Node g, Node start) {
        Traverser traverser = Traverser.forGraph(n -> this.getDirectNodes(g, (Node)n));
        Iter result = Iter.iter(traverser.depthFirstPreOrder((Object)start).iterator());
        return result;
    }

    private Set<Node> getDirectNodes(Node g, Node start) {
        Set<Node> result = start.isLiteral() ? Collections.emptySet() : this.loadDirectNodes(g, start);
        return result;
    }

    private Set<Node> loadDirectNodes(Node g, Node s) {
        Set result = this.findDirectTriples(g, s).toSet();
        return result;
    }

    private Iter<Node> findDirectTriples(Node g, Node s) {
        return Iter.concat((Iter)Iter.iter(this.sameAsPredicates).flatMap(p -> this.findDirectNodes(g, s, (Node)p, true)), (Iter)Iter.iter(this.sameAsPredicates).flatMap(p -> this.findDirectNodes(g, s, (Node)p, false)));
    }

    private Iter<Node> findDirectNodes(Node g, Node s, Node p, boolean isForward) {
        Iter result = isForward ? Iter.iter((Iterator)this.getR().find(g, s, p, Node.ANY)).map(Quad::getObject) : Iter.iter((Iterator)this.getR().find(g, Node.ANY, p, s)).map(Quad::getSubject);
        return result;
    }
}

