/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.sameas.init;

import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.jenax.arq.sameas.assembler.DatasetAssemblerRdfsReduced;
import org.aksw.jenax.arq.sameas.assembler.DatasetAssemblerRdfsReducedEnable;
import org.aksw.jenax.arq.sameas.assembler.DatasetAssemblerSameAs;
import org.aksw.jenax.arq.sameas.assembler.SameAsVocab;
import org.aksw.jenax.arq.sameas.model.SameAsConfig;
import org.aksw.jenax.arq.uniondefaultgraph.assembler.DatasetAssemblerUnionDefaultGraph;
import org.aksw.jenax.arq.uniondefaultgraph.assembler.UnionDefaultGraphVocab;
import org.aksw.jenax.arq.util.dataset.DatasetGraphRDFSReduced;
import org.aksw.jenax.arq.util.dataset.DatasetGraphSameAs;
import org.aksw.jenax.arq.util.dataset.DatasetGraphUnionDefaultGraph;
import org.aksw.jenax.arq.util.exec.query.QueryExecUtils;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.assemblers.AssemblerGroup;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfs.SetupRDFS;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sys.JenaSubsystemLifecycle;

public class SameAsInit
implements JenaSubsystemLifecycle {
    public void start() {
        SameAsInit.init();
    }

    public void stop() {
    }

    public static void init() {
        JenaPluginUtils.registerResourceClasses((Class[])new Class[]{SameAsConfig.class});
        SameAsInit.registerWith(Assembler.general);
        SameAsInit.registerServiceWrapper("sameAs", execCxt -> DatasetGraphSameAs.wrap((DatasetGraph)DatasetGraphUnionDefaultGraph.wrapIfNeeded((DatasetGraph)execCxt.getDataset())));
        SameAsInit.registerServiceWrapper("sameAs+rdfs", execCxt -> {
            SetupRDFS setup = Objects.requireNonNull((SetupRDFS)execCxt.getContext().get(DatasetAssemblerRdfsReduced.symSetupRdfsNode), "No RDFS setup found in the active dataset context");
            return DatasetGraphRDFSReduced.wrap((DatasetGraph)DatasetGraphSameAs.wrap((DatasetGraph)DatasetGraphUnionDefaultGraph.wrapIfNeeded((DatasetGraph)execCxt.getDataset())), (ConfigRDFS)setup);
        });
        SameAsInit.registerServiceWrapper("rdfs", execCxt -> {
            SetupRDFS setup = Objects.requireNonNull((SetupRDFS)execCxt.getContext().get(DatasetAssemblerRdfsReduced.symSetupRdfsNode), "No RDFS setup found in the active dataset context");
            return DatasetGraphRDFSReduced.wrap((DatasetGraph)DatasetGraphUnionDefaultGraph.wrapIfNeeded((DatasetGraph)execCxt.getDataset()), (ConfigRDFS)setup);
        });
    }

    public static void registerServiceWrapper(String serviceName, Function<ExecutionContext, ? extends DatasetGraph> wrapper) {
        Pattern servicePattern = Pattern.compile("^" + Pattern.quote(serviceName) + "($|:)");
        ServiceExecutorRegistry.get().addSingleLink((opExec, opOrig, binding, execCxt, chain) -> {
            String uri;
            Matcher m;
            QueryIterator r = null;
            Node node = opExec.getService();
            if (node != null && node.isURI() && (m = servicePattern.matcher(uri = node.getURI())).find()) {
                if (m.end() < uri.length()) {
                    throw new RuntimeException("Trailing characters found after '" + m.group() + "': " + uri.substring(m.end()));
                }
                DatasetGraph adhocDs = (DatasetGraph)wrapper.apply(execCxt);
                r = QueryExecUtils.execute((Op)opExec.getSubOp(), (DatasetGraph)adhocDs, (Binding)binding, (Context)execCxt.getContext());
            }
            if (r == null) {
                r = chain.createExecution(opExec, opOrig, binding, execCxt);
            }
            return r;
        });
    }

    static void registerWith(AssemblerGroup g) {
        AssemblerUtils.register((AssemblerGroup)g, (Resource)SameAsVocab.DatasetSameAs, (Assembler)new DatasetAssemblerSameAs(), (Resource)DatasetAssembler.getGeneralType());
        AssemblerUtils.register((AssemblerGroup)g, (Resource)DatasetAssemblerRdfsReduced.getType(), (Assembler)new DatasetAssemblerRdfsReduced(), (Resource)DatasetAssembler.getGeneralType());
        AssemblerUtils.register((AssemblerGroup)g, (Resource)DatasetAssemblerRdfsReducedEnable.getType(), (Assembler)new DatasetAssemblerRdfsReducedEnable(), (Resource)DatasetAssembler.getGeneralType());
        AssemblerUtils.register((AssemblerGroup)g, (Resource)UnionDefaultGraphVocab.DatasetUnionDefaultGraph, (Assembler)new DatasetAssemblerUnionDefaultGraph(false), (Resource)DatasetAssembler.getGeneralType());
        AssemblerUtils.register((AssemblerGroup)g, (Resource)UnionDefaultGraphVocab.DatasetAutoUnionDefaultGraph, (Assembler)new DatasetAssemblerUnionDefaultGraph(true), (Resource)DatasetAssembler.getGeneralType());
    }
}

