/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.sameas.dataset;

import com.google.common.base.Stopwatch;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.aksw.jenax.arq.sameas.dataset.DatasetGraphSameAsOld;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;

public class DatasetSameAsExperiments {
    public static void main3(String[] args) {
        List values = IntStream.range(0, 1000).boxed().collect(Collectors.toList());
        Stream<Map.Entry> stream = values.stream().flatMap(x -> values.stream().map(y -> Map.entry(x, y))).flatMap(e -> IntStream.range(0, 10).boxed().map(z -> Map.entry(String.valueOf(e.getKey()) + "x" + String.valueOf(e.getValue()), z))).peek(e -> System.out.println(String.valueOf(Thread.currentThread()) + " Got value"));
        Iterator it = stream.iterator();
        while (it.hasNext()) {
            System.err.println(String.valueOf(Thread.currentThread()) + " Result Item: " + String.valueOf(it.next()));
        }
    }

    public static void main(String[] args) {
        Stopwatch sw = Stopwatch.createStarted();
        DatasetGraph base = DatasetGraphFactory.createTxnMem();
        Txn.executeWrite((Transactional)base, () -> {
            RDFDataMgr.read((DatasetGraph)base, (String)"/home/raven/Datasets/coypu/countries-deu.nt");
            RDFDataMgr.read((DatasetGraph)base, (String)"/home/raven/Datasets/coypu/countries-deu-wikidata.nt");
        });
        System.out.println("Finished loading in " + sw.elapsed(TimeUnit.SECONDS));
        sw.reset().start();
        DatasetGraph dsg = DatasetGraphSameAsOld.wrap(base);
        Txn.executeRead((Transactional)dsg, () -> {
            Iterator it = dsg.find();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                if (++i % 100000 != 0) continue;
                System.out.println("Current count: " + i + " elapsed: " + sw.elapsed(TimeUnit.SECONDS));
            }
            System.out.println("Current count: " + i + " elapsed: " + sw.elapsed(TimeUnit.SECONDS));
            Iter.close((Iterator)it);
        });
        System.out.println("Finished action in " + sw.elapsed(TimeUnit.SECONDS));
    }

    public static void main2(String[] args) {
        DatasetGraph base = DatasetGraphFactory.createTxnMem();
        DatasetGraph datasetGraph = DatasetGraphSameAsOld.wrap(base);
        Dataset dataset = DatasetFactory.wrap((DatasetGraph)datasetGraph);
        Model model = dataset.getDefaultModel();
        Resource s = model.createResource("urn:example:s");
        Resource o = model.createResource("urn:example:o");
        s.addProperty(RDFS.label, "s").addProperty(OWL.sameAs, (RDFNode)o);
        o.addProperty(RDFS.label, "o").addProperty(RDFS.label, "s");
        System.out.println("trig:");
        RDFDataMgr.write((OutputStream)System.out, (Dataset)dataset, (RDFFormat)RDFFormat.TRIG_PRETTY);
        System.out.println("find:");
        dataset.asDatasetGraph().find().forEachRemaining(System.out::println);
        System.out.println("s:");
        s.listProperties().forEachRemaining(System.out::println);
        System.out.println("o:");
        o.listProperties().forEachRemaining(System.out::println);
        System.out.println("labels:");
        model.listStatements(null, RDFS.label, (RDFNode)null).forEachRemaining(System.out::println);
    }

    private static /* synthetic */ Stream lambda$main3$3(List values, Integer x) {
        return values.stream().flatMap(y -> IntStream.range(0, 10).boxed().map(z -> Map.entry(x + "x" + y, z)).peek(e -> System.out.println(String.valueOf(Thread.currentThread()) + " Got value")));
    }
}

