/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.query.rx;

import com.google.common.collect.ArrayListMultimap;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jena_sparql_api.rx.ModelFactoryEx;
import org.aksw.jenax.arq.dataset.orderaware.DatasetFactoryEx;
import org.aksw.jenax.arq.util.irixresolver.IRIxResolverUtils;
import org.aksw.jenax.arq.util.lang.RDFLanguagesEx;
import org.aksw.jenax.arq.util.streamrdf.StreamRDFWriterEx;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrRx;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.resultset.ResultSetReaderRegistry;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.AsyncParserBuilder;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sys.JenaSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFDataMgrEx {
    private static final Logger logger = LoggerFactory.getLogger(RDFDataMgrEx.class);
    public static final List<Lang> DEFAULT_PROBE_LANGS;

    public static String toString(Model model, RDFFormat rdfFormat) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out, (Model)model, (RDFFormat)rdfFormat);
        return out.toString(StandardCharsets.UTF_8);
    }

    public static String toString(Dataset dataset, RDFFormat rdfFormat) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out, (Dataset)dataset, (RDFFormat)rdfFormat);
        return out.toString(StandardCharsets.UTF_8);
    }

    public static boolean isStdIn(String filenameOrIri) {
        return "-".equals(filenameOrIri);
    }

    public static Lang getLang(TypedInputStream tin) {
        ContentType ct = tin.getMediaType();
        Lang result = RDFLanguages.contentTypeToLang((ContentType)ct);
        return result;
    }

    public static void read(Model model, TypedInputStream tin) {
        Lang lang = RDFDataMgrEx.getLang(tin);
        RDFParser.create().forceLang(lang).source(tin.getInputStream()).base(tin.getBaseURI()).parse(model);
    }

    public static TypedInputStream forceBuffered(TypedInputStream tin) {
        TypedInputStream result = tin.markSupported() ? tin : RDFDataMgrEx.wrapInputStream(new BufferedInputStream(tin.getInputStream()), tin);
        return result;
    }

    public static InputStream forceBuffered(InputStream in) {
        InputStream result = in.markSupported() ? in : new BufferedInputStream(in);
        return result;
    }

    public static TypedInputStream wrapInputStream(InputStream in, TypedInputStream proto) {
        TypedInputStream result = new TypedInputStream(in, proto.getMediaType(), proto.getBaseURI());
        return result;
    }

    public static InputStream decode(InputStream in, List<String> codecs) throws CompressorException {
        return RDFDataMgrEx.decode(in, codecs, CompressorStreamFactory.getSingleton());
    }

    public static InputStream decode(InputStream in, List<String> codecs, CompressorStreamFactory csf) throws CompressorException {
        InputStream result = in;
        for (String encoding : codecs) {
            result = csf.createCompressorInputStream(encoding, result, true);
        }
        return result;
    }

    public static OutputStream encode(OutputStream out, List<String> codecs, CompressorStreamFactory csf) throws CompressorException {
        OutputStream result = out;
        for (String encoding : codecs) {
            result = csf.createCompressorOutputStream(encoding, result);
        }
        return result;
    }

    public static Function<OutputStream, OutputStream> encoder(String ... codecs) {
        List<String> list = Arrays.asList(codecs);
        return RDFDataMgrEx.encoder(list);
    }

    public static Function<OutputStream, OutputStream> encoder(List<String> codecs) {
        CompressorStreamFactory csf = CompressorStreamFactory.getSingleton();
        return RDFDataMgrEx.encoder(csf, codecs);
    }

    public static Function<OutputStream, OutputStream> encoder(CompressorStreamFactory csf, List<String> codecs) {
        return out -> {
            try {
                return RDFDataMgrEx.encode(out, codecs, csf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream probeEncodings(InputStream is, List<String> outEncodings) throws IOException {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("Encoding probing requires an input stream with mark support");
        }
        ArrayList<String> detectedEncodings = new ArrayList<String>();
        CompressorStreamFactory csf = CompressorStreamFactory.getSingleton();
        RDFDataMgrEx.setDefaultMark(is);
        InputStream probeIn = null;
        while (true) {
            String encoding;
            try {
                BufferedInputStream shieldedIs = new BufferedInputStream((InputStream)CloseShieldInputStream.wrap((InputStream)is));
                probeIn = RDFDataMgrEx.decode(shieldedIs, detectedEncodings, csf);
                probeIn = RDFDataMgrEx.forceBuffered(probeIn);
                encoding = CompressorStreamFactory.detect((InputStream)probeIn);
            }
            catch (CompressorException e) {
                break;
            }
            finally {
                if (probeIn != null) {
                    probeIn.close();
                }
                is.reset();
            }
            detectedEncodings.add(encoding);
            if (outEncodings == null) continue;
            outEncodings.add(encoding);
        }
        try {
            probeIn = RDFDataMgrEx.decode(is, detectedEncodings, csf);
        }
        catch (CompressorException e) {
            throw new RuntimeException(e);
        }
        return probeIn;
    }

    public static RdfEntityInfo probeEntityInfo(Callable<InputStream> inSupp, Iterable<Lang> candidates) throws IOException {
        RdfEntityInfo result;
        try (InputStream in = RDFDataMgrEx.forceBuffered(inSupp.call());){
            result = RDFDataMgrEx.probeEntityInfo(in, candidates);
        }
        catch (IOException e) {
            e.addSuppressed(new RuntimeException());
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return result;
    }

    public static RdfEntityInfo probeEntityInfo(Path path, Iterable<Lang> candidates) throws IOException {
        return RDFDataMgrEx.probeEntityInfo(() -> Files.newInputStream(path, StandardOpenOption.READ), candidates);
    }

    public static RdfEntityInfo probeEntityInfo(InputStream in, Iterable<Lang> candidates) throws IOException {
        RdfEntityInfo result;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        try (InputStream is = in;){
            ArrayList<String> encodings = new ArrayList<String>();
            InputStream nextIn = RDFDataMgrEx.probeEncodings(is, encodings);
            nextIn = RDFDataMgrEx.forceBuffered(nextIn);
            try (TypedInputStream tis = RDFDataMgrEx.probeLang(nextIn, candidates);){
                String contentType = tis.getContentType();
                String charset = tis.getCharset();
                result = (RdfEntityInfo)ModelFactory.createDefaultModel().createResource().as(RdfEntityInfo.class);
                result.getContentEncodings().addAll(encodings);
                result.setContentType(contentType);
                result.setCharset(charset);
            }
        }
        return result;
    }

    public static TypedInputStream probeLang(InputStream in, Iterable<Lang> candidates, Collection<Map.Entry<Lang, Throwable>> errorCollector) {
        return RDFDataMgrEx.probeLang(in, candidates, true, errorCollector);
    }

    public static TypedInputStream probeLang(InputStream in, Iterable<Lang> candidates) {
        return RDFDataMgrEx.probeLang(in, candidates, new ArrayList<Map.Entry<Lang, Throwable>>());
    }

    public static void setDefaultMark(InputStream in) {
        in.mark(0x40000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypedInputStream probeLang(InputStream in, Iterable<Lang> candidates, boolean tryAllCandidates, Collection<Map.Entry<Lang, Throwable>> errorCollector) {
        Map.Entry bestCand;
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Language probing requires an input stream with mark support");
        }
        RDFDataMgrEx.setDefaultMark(in);
        ArrayListMultimap successCountToLang = ArrayListMultimap.create();
        for (Lang cand : candidates) {
            Stream flow;
            CloseShieldInputStream wbin = CloseShieldInputStream.wrap((InputStream)in);
            AsyncParserBuilder builder = AsyncParser.of((InputStream)wbin, (Lang)cand, null).mutateSources(parser -> parser.errorHandler(ErrorHandlerFactory.errorHandlerSimple())).setChunkSize(100).setQueueSize(10);
            if (RDFLanguages.isQuads((Lang)cand)) {
                flow = builder.streamQuads();
            } else if (RDFLanguages.isTriples((Lang)cand)) {
                flow = builder.streamTriples();
            } else if (ResultSetReaderRegistry.isRegistered((Lang)cand)) {
                flow = RDFDataMgrRx.createFlowableBindings(() -> wbin, cand).blockingStream();
            } else {
                logger.warn("Skipping probing of unknown Lang: " + String.valueOf(cand));
                continue;
            }
            int n = 100;
            try (Stream s = flow;){
                long count;
                Iterator it = s.iterator();
                for (count = 0L; count < (long)n && it.hasNext(); ++count) {
                    it.next();
                }
                successCountToLang.put((Object)count, (Object)cand);
                logger.debug("Number of items parsed by content type probing for " + String.valueOf(cand) + ": " + count);
            }
            catch (Exception e) {
                logger.debug("Failed to probe with format " + String.valueOf(cand), (Throwable)e);
                if (errorCollector == null) continue;
                errorCollector.add((Map.Entry<Lang, Throwable>)Pair.of((Object)cand, (Object)e));
                continue;
            }
            finally {
                try {
                    in.reset();
                    continue;
                }
                catch (IOException x) {
                    throw new RuntimeException(x);
                }
            }
            if (tryAllCandidates) continue;
            break;
        }
        ContentType bestContentType = (bestCand = (Map.Entry)successCountToLang.entries().stream().sorted((a, b) -> ((Long)b.getKey()).compareTo((Long)a.getKey())).findFirst().orElse(null)) == null ? null : ((Lang)bestCand.getValue()).getContentType();
        TypedInputStream result = new TypedInputStream(in, bestContentType);
        return result;
    }

    public static TypedInputStream probeLang(InputStream in, Iterable<Lang> candidates, boolean tryAllCandidates) {
        return RDFDataMgrEx.probeLang(in, candidates, tryAllCandidates, new ArrayList<Map.Entry<Lang, Throwable>>());
    }

    public static void peek(InputStream in) {
        RDFDataMgrEx.setDefaultMark(in);
        try {
            System.err.println("GOT:");
            System.err.println(IOUtils.toString((InputStream)in));
            System.err.println("DONE");
            in.reset();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TypedInputStream open(String src, Iterable<Lang> probeLangs, Collection<Map.Entry<Lang, Throwable>> errorCollector) {
        TypedInputStream result;
        Objects.requireNonNull(src);
        boolean useStdIn = RDFDataMgrEx.isStdIn(src);
        if (useStdIn) {
            result = RDFDataMgrEx.probeLang(new BufferedInputStream(System.in), probeLangs);
        } else {
            result = Objects.requireNonNull(RDFDataMgr.open((String)src), "Could not create input stream from " + src);
            result = RDFDataMgrEx.probeForSpecificLang(result, probeLangs, errorCollector);
        }
        return result;
    }

    public static TypedInputStream open(String src, Iterable<Lang> probeLangs) {
        return RDFDataMgrEx.open(src, probeLangs, new ArrayList<Map.Entry<Lang, Throwable>>());
    }

    public static TypedInputStream open(Path path, Iterable<Lang> probeLangs, Collection<Map.Entry<Lang, Throwable>> errorCollector) {
        InputStream in;
        try {
            in = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return RDFDataMgrEx.probeForSpecificLang(new TypedInputStream(in, (ContentType)null), probeLangs, errorCollector);
    }

    public static TypedInputStream open(Path path, Iterable<Lang> probeLangs) {
        return RDFDataMgrEx.open(path, probeLangs, null);
    }

    public static TypedInputStream probeForSpecificLang(TypedInputStream result, Iterable<Lang> probeLangs, Collection<Map.Entry<Lang, Throwable>> errorCollector) {
        Set expandedLangs = RDFLanguagesEx.expandWithSubLangs(probeLangs);
        ContentType mediaType = result.getMediaType();
        if (mediaType != null) {
            String mediaTypeStr = mediaType.toHeaderString();
            boolean mediaTypeInProbeLangs = expandedLangs.stream().anyMatch(lang -> RDFLanguagesEx.getAllContentTypes((Lang)lang).contains(mediaTypeStr));
            if (!mediaTypeInProbeLangs) {
                mediaType = null;
            }
        }
        if (mediaType == null) {
            result = RDFDataMgrEx.probeLang(RDFDataMgrEx.forceBuffered(result.getInputStream()), probeLangs, errorCollector);
        }
        return result;
    }

    public static Dataset parseTrigAgainstDataset(Dataset dataset, PrefixMapping prefixMapping, InputStream in) {
        InputStream combined = RDFDataMgrEx.prependWithPrefixes(in, prefixMapping);
        RDFDataMgr.read((Dataset)dataset, (InputStream)combined, (Lang)Lang.TRIG);
        return dataset;
    }

    public static Model parseTurtleAgainstModel(Model model, PrefixMapping prefixMapping, InputStream in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Model tmp = ModelFactory.createDefaultModel();
        tmp.setNsPrefixes(prefixMapping);
        RDFDataMgr.write((OutputStream)baos, (Model)tmp, (Lang)Lang.TURTLE);
        SequenceInputStream combined = new SequenceInputStream(new ByteArrayInputStream(baos.toByteArray()), in);
        RDFDataMgr.read((Model)model, (InputStream)combined, (Lang)Lang.TURTLE);
        return model;
    }

    public static InputStream prependWithPrefixes(InputStream in, PrefixMapping prefixMapping) {
        return RDFDataMgrEx.prependWithPrefixes(in, prefixMapping, RDFFormat.TURTLE_PRETTY);
    }

    public static InputStream prependWithPrefixes(InputStream in, PrefixMapping prefixMapping, RDFFormat fmt) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Model tmp = ModelFactory.createDefaultModel();
        tmp.setNsPrefixes(prefixMapping);
        RDFDataMgr.write((OutputStream)baos, (Model)tmp, (RDFFormat)fmt);
        SequenceInputStream combined = new SequenceInputStream(new ByteArrayInputStream(baos.toByteArray()), in);
        return combined;
    }

    public static TypedInputStream prependWithPrefixes(TypedInputStream in, PrefixMapping prefixMapping) {
        InputStream combined = RDFDataMgrEx.prependWithPrefixes(in.getInputStream(), prefixMapping);
        TypedInputStream result = new TypedInputStream(combined, in.getMediaType(), in.getBaseURI());
        return result;
    }

    public static RDFParserBuilder newParserBuilderForReadAsGiven(String baseIri) {
        IRIxResolver resolver = IRIxResolverUtils.newIRIxResolverAsGiven((String)baseIri);
        return RDFParser.create().resolver(resolver).context(null).base(null).errorHandler(RDFDataMgrRx.dftErrorHandler()).labelToNode(RDFDataMgrRx.createLabelToNodeAsGivenOrRandom());
    }

    public static Graph readAsGiven(Graph graph, String uri) {
        RDFDataMgrEx.newParserBuilderForReadAsGiven(null).source(uri).parse(graph);
        return graph;
    }

    public static Model readAsGiven(Model model, String uri) {
        RDFDataMgrEx.newParserBuilderForReadAsGiven(null).source(uri).parse(model);
        return model;
    }

    public static DatasetGraph readAsGiven(DatasetGraph datasetGraph, String uri) {
        RDFDataMgrEx.newParserBuilderForReadAsGiven(null).source(uri).parse(datasetGraph);
        return datasetGraph;
    }

    public static Dataset readAsGiven(Dataset dataset, String uri) {
        RDFDataMgrEx.newParserBuilderForReadAsGiven(null).source(uri).parse(dataset);
        return dataset;
    }

    public static Model loadModelAsGiven(String uri) {
        Model result = ModelFactoryEx.createInsertOrderPreservingModel();
        RDFDataMgrEx.readAsGiven(result, uri);
        return result;
    }

    public static DatasetGraph readAsGiven(DatasetGraph datasetGraph, String uri, String baseIri) {
        RDFDataMgrEx.newParserBuilderForReadAsGiven(baseIri).source(uri).parse(datasetGraph);
        return datasetGraph;
    }

    public static Dataset readAsGiven(Dataset dataset, String uri, String baseIri) {
        RDFDataMgrEx.readAsGiven(dataset.asDatasetGraph(), uri, baseIri);
        return dataset;
    }

    public static DatasetGraph readAsGiven(DatasetGraph datasetGraph, InputStream in, Lang lang) {
        RDFDataMgrEx.newParserBuilderForReadAsGiven(null).source(in).lang(lang).build().parse(datasetGraph);
        return datasetGraph;
    }

    public static Dataset readAsGiven(Dataset dataset, InputStream in, Lang lang) {
        RDFDataMgrEx.readAsGiven(dataset.asDatasetGraph(), in, lang);
        return dataset;
    }

    public static Dataset loadDatasetAsGiven(String uri, String baseIri) {
        Dataset result = DatasetFactoryEx.createInsertOrderPreservingDataset();
        RDFDataMgrEx.readAsGiven(result, uri, baseIri);
        return result;
    }

    public static void writeAsGiven(OutputStream out, Model model, RDFFormat rdfFormat, String baseIri) {
        RDFDataMgrEx.writeAsGiven(out, DatasetFactory.wrap((Model)model), rdfFormat, baseIri);
    }

    public static void writeAsGiven(OutputStream out, Dataset dataset, RDFFormat rdfFormat, String baseIri) {
        RDFDataMgrEx.writeAsGiven(out, dataset.asDatasetGraph(), rdfFormat, baseIri);
    }

    public static void writeAsGiven(OutputStream out, DatasetGraph datasetGraph, RDFFormat rdfFormat, String baseIri) {
        Context cxt = RIOT.getContext().copy();
        cxt.setTrue(RIOT.symTurtleOmitBase);
        IRIx irix = baseIri == null ? null : IRIx.create((String)baseIri);
        StreamRDF writer = StreamRDFWriterEx.getWriterStream((OutputStream)out, (RDFFormat)rdfFormat, (Context)cxt, null, (IRIx)irix, null, (Boolean)true);
        writer.start();
        StreamRDFOps.sendDatasetToStream((DatasetGraph)datasetGraph, (StreamRDF)writer);
        writer.finish();
    }

    public static Dataset printParseRoundtrip(Dataset dataset, RDFFormat rdfFormat, Dataset result) {
        if (result == null) {
            result = DatasetFactory.create();
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            RDFDataMgr.write((OutputStream)out, (Dataset)dataset, (RDFFormat)rdfFormat);
            try (ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());){
                RDFDataMgr.read((Dataset)result, (InputStream)in, (Lang)rdfFormat.getLang());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static Model printParseRoundtrip(Model model, RDFFormat rdfFormat, Model result) {
        if (result == null) {
            result = ModelFactory.createDefaultModel();
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            RDFDataMgr.write((OutputStream)out, (Model)model, (RDFFormat)rdfFormat);
            try (ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());){
                RDFDataMgr.read((Model)result, (InputStream)in, (Lang)rdfFormat.getLang());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static <T extends RDFNode> Optional<T> tryLoadResourceWithProperty(String src, Property p, Class<T> clazz) {
        Model configModel = RDFDataMgr.loadModel((String)src);
        Optional<RDFNode> result = configModel.listResourcesWithProperty(p).nextOptional().map(x -> x.as(clazz));
        return result;
    }

    static {
        JenaSystem.init();
        DEFAULT_PROBE_LANGS = Collections.unmodifiableList(Arrays.asList(RDFLanguages.TRIG, RDFLanguages.JSONLD, RDFLanguages.RDFXML, RDFLanguages.RDFTHRIFT));
    }
}

