/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.script;

import com.codepoetics.protonpack.StreamUtils;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.jena.riot.Lang;

public class MultiException
extends Exception {
    private final Collection<Map.Entry<Lang, Throwable>> langParseExceptions;
    private final Collection<Throwable> stmtParseExceptions;

    public MultiException(String message, Collection<Map.Entry<Lang, Throwable>> langParseExceptions, Collection<Throwable> stmtParseExceptions) {
        super(message);
        this.langParseExceptions = langParseExceptions;
        langParseExceptions.forEach(e -> this.addSuppressed((Throwable)e.getValue()));
        this.stmtParseExceptions = stmtParseExceptions;
        stmtParseExceptions.forEach(this::addSuppressed);
        if (langParseExceptions.size() + stmtParseExceptions.size() == 1) {
            this.initCause(stmtParseExceptions.isEmpty() ? langParseExceptions.iterator().next().getValue() : stmtParseExceptions.iterator().next());
        }
    }

    public Collection<Map.Entry<Lang, Throwable>> getLangParseExceptions() {
        return this.langParseExceptions;
    }

    public Collection<Throwable> getStmtParseExceptions() {
        return this.stmtParseExceptions;
    }

    public static String getEMessage(Throwable e) {
        Matcher m;
        String eMessage = e.getMessage();
        Matcher matcher = m = eMessage != null ? Pattern.compile("^(\\w+(\\.\\w+)+: )+(.*)$").matcher(eMessage) : null;
        if (m != null && m.find()) {
            return m.group(1) + m.group(3);
        }
        return e.getClass().getName() + (String)(eMessage == null ? "" : ": " + eMessage);
    }

    @Override
    public String getMessage() {
        String langMessages = "Language parse problems:\n" + this.langParseExceptions.stream().filter(e -> ((Throwable)e.getValue()).getMessage() != null).map(e -> ((Lang)e.getKey()).toString() + ": " + MultiException.getEMessage((Throwable)e.getValue())).collect(Collectors.joining("\n"));
        String stmtMessages = "Statement parse problems:\n" + StreamUtils.zipWithIndex(this.stmtParseExceptions.stream()).filter(e -> ((Throwable)e.getValue()).getMessage() != null).map(e -> e.getIndex() + ": " + MultiException.getEMessage((Throwable)e.getValue())).collect(Collectors.joining("\n"));
        return super.getMessage() + "\n" + (String)(!this.langParseExceptions.isEmpty() ? langMessages : "") + (!this.langParseExceptions.isEmpty() && !this.stmtParseExceptions.isEmpty() ? "\n\n" : "") + (String)(!this.stmtParseExceptions.isEmpty() ? stmtMessages : "");
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        this.langParseExceptions.forEach(e -> {
            s.println("Language parse problem (" + ((Lang)e.getKey()).getName() + ")");
            ((Throwable)e.getValue()).printStackTrace(s);
        });
        this.stmtParseExceptions.forEach(ex -> {
            s.println("Statement parse problem");
            ex.printStackTrace(s);
        });
    }
}

