/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.query_flow;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aksw.commons.util.stream.StreamFunction;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public class QueryStreamOps {
    public static StreamFunction<Binding, Triple> createMapperTriples(Query query) {
        Preconditions.checkArgument((!query.isConstructType() ? 1 : 0) != 0, (Object)"Construct query expected");
        Template template = query.getConstructTemplate();
        Op op = Algebra.compile((Query)query);
        return (StreamFunction & Serializable)upstream -> (Stream)StreamFunction.identity(Binding.class).andThen(QueryStreamOps.createMapperBindings(op)).andThenFlatMap(QueryStreamOps.createMapperTriples(template)::apply).apply(upstream);
    }

    public static StreamFunction<Binding, Quad> createMapperQuads(Query query) {
        Preconditions.checkArgument((boolean)query.isConstructType(), (Object)"Construct query expected");
        Template template = query.getConstructTemplate();
        Op op = Algebra.compile((Query)query);
        return (StreamFunction & Serializable)upstream -> (Stream)StreamFunction.identity(Binding.class).andThen(QueryStreamOps.createMapperBindings(op)).andThenFlatMap(QueryStreamOps.createMapperQuads(template)::apply).apply(upstream);
    }

    public static StreamFunction<Binding, Binding> createMapperBindings(Op op) {
        return (StreamFunction & Serializable)upstream -> {
            DatasetGraph ds = DatasetGraphFactory.empty();
            Context cxt = ARQ.getContext().copy();
            ExecutionContext execCxt = new ExecutionContext(cxt, ds.getDefaultGraph(), ds, QC.getFactory((Context)cxt));
            return upstream.flatMap(binding -> Iter.asStream((Iterator)QC.execute((Op)op, (Binding)binding, (ExecutionContext)execCxt)));
        };
    }

    public static Function<Binding, Stream<Triple>> createMapperTriples(Template template) {
        return binding -> Iter.asStream((Iterator)TemplateLib.calcTriples((List)template.getTriples(), Collections.singleton(binding).iterator()));
    }

    public static Function<Binding, Stream<Quad>> createMapperQuads(Template template) {
        return binding -> Iter.asStream((Iterator)TemplateLib.calcQuads((List)template.getQuads(), Collections.singleton(binding).iterator()));
    }

    public static ExecutionContext createExecutionContextDefault() {
        Context context = ARQ.getContext().copy();
        context.set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        ExecutionContext result = new ExecutionContext(context, null, null, null);
        return result;
    }
}

