/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.io.resultset;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.rx.io.resultset.OutputMode;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExVisitor;
import org.aksw.jenax.stmt.resultset.SPARQLResultEx;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.algebra.table.TableN;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;

public class SPARQLResultExVisitorCollector
implements SPARQLResultExVisitor<Void> {
    protected Collection<Quad> quads;
    protected TableN table;
    protected Collection<JsonObject> jsonItems;

    public SPARQLResultExVisitorCollector(List<Var> tableVars) {
        this(new ArrayList<Quad>(), new TableN(tableVars), new ArrayList<JsonObject>());
    }

    public SPARQLResultExVisitorCollector(Collection<Quad> quads, TableN table, Collection<JsonObject> jsonItems) {
        this.quads = quads;
        this.table = table;
        this.jsonItems = jsonItems;
    }

    public Collection<Quad> getQuads() {
        return this.quads;
    }

    public TableN getTable() {
        return this.table;
    }

    public Collection<JsonObject> getJsonItems() {
        return this.jsonItems;
    }

    public SPARQLResultEx getResult(OutputMode outputMode) {
        return switch (outputMode) {
            case OutputMode.BINDING -> new SPARQLResultEx(ResultSet.adapt((RowSet)this.table.toRowSet()), () -> {});
            case OutputMode.QUAD -> SPARQLResultEx.createQuads(this.quads.iterator(), () -> {});
            case OutputMode.JSON -> new SPARQLResultEx(this.jsonItems.iterator(), () -> {});
            default -> throw new IllegalStateException("Unknown output mode: " + String.valueOf((Object)outputMode));
        };
    }

    public ResultSet getResultSet() {
        return ResultSet.adapt((RowSet)this.table.toRowSet());
    }

    @Override
    public Void onQuads(Iterator<Quad> it) {
        while (it.hasNext()) {
            Quad quad = it.next();
            this.quads.add(quad);
        }
        return null;
    }

    @Override
    public Void onTriples(Iterator<Triple> it) {
        this.onQuads(Iterators.transform(it, t -> new Quad(Quad.defaultGraphIRI, t)));
        return null;
    }

    @Override
    public Void onBooleanResult(Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Void onResultSet(ResultSet it) {
        while (it.hasNext()) {
            Binding binding = it.nextBinding();
            this.table.addBinding(binding);
        }
        return null;
    }

    @Override
    public Void onJsonItems(Iterator<JsonObject> it) {
        while (it.hasNext()) {
            JsonObject json = it.next();
            this.jsonItems.add(json);
        }
        return null;
    }
}

