/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.rx.op;

import com.google.common.base.Preconditions;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.commons.lambda.throwing.ThrowingSupplier;
import org.aksw.commons.rx.util.FlowableEx;
import org.aksw.jena_sparql_api.rx.query_flow.QueryFlowAssign;
import org.aksw.jena_sparql_api.rx.query_flow.QueryFlowGroupBy;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.SortCondition;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingProject;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.reactivestreams.Publisher;

public class QueryFlowOps {
    public static FlowableTransformer<Binding, Triple> createMapperTriples(Query query) {
        Preconditions.checkArgument((!query.isConstructType() ? 1 : 0) != 0, (Object)"Construct query expected");
        Template template = query.getConstructTemplate();
        return upstream -> upstream.compose(QueryFlowOps.createMapperBindings(query)).flatMap(QueryFlowOps.createMapperTriples(template)::apply);
    }

    public static FlowableTransformer<Binding, Quad> createMapperQuads(Query query) {
        Preconditions.checkArgument((boolean)query.isConstructType(), (Object)"Construct query expected");
        Template template = query.getConstructTemplate();
        return upstream -> upstream.compose(QueryFlowOps.createMapperBindings(query)).flatMap(QueryFlowOps.createMapperQuads(template)::apply);
    }

    public static FlowableTransformer<Binding, Binding> createMapperBindings(Query query) {
        Op op = Algebra.compile((Query)query);
        return QueryFlowOps.createMapperBindings(op);
    }

    public static FlowableTransformer<Binding, Binding> createMapperBindings(Op op) {
        return upstream -> {
            DatasetGraph ds = DatasetGraphFactory.create();
            Context cxt = ARQ.getContext().copy();
            ExecutionContext execCxt = new ExecutionContext(cxt, ds.getDefaultGraph(), ds, QC.getFactory((Context)cxt));
            return upstream.flatMap(binding -> FlowableEx.fromIteratorSupplier((ThrowingSupplier & Serializable)() -> QC.execute((Op)op, (Binding)binding, (ExecutionContext)execCxt), Closeable::close));
        };
    }

    public static Function<Binding, Flowable<Triple>> createMapperTriples(Template template) {
        return binding -> Flowable.fromIterable(() -> TemplateLib.calcTriples((List)template.getTriples(), Collections.singleton(binding).iterator()));
    }

    public static Function<Binding, Flowable<Quad>> createMapperQuads(Template template) {
        return binding -> Flowable.fromIterable(() -> TemplateLib.calcQuads((List)template.getQuads(), Collections.singleton(binding).iterator()));
    }

    public static ExecutionContext createExecutionContextDefault() {
        Context context = ARQ.getContext().copy();
        context.set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        ExecutionContext result = new ExecutionContext(context, null, null, null);
        return result;
    }

    public static FlowableTransformer<Binding, Binding> transformerFromQuery(String queryStr) {
        Query query = QueryFactory.create((String)queryStr, (Syntax)Syntax.syntaxARQ);
        FlowableTransformer<Binding, Binding> result = QueryFlowOps.transformerFromQuery(query);
        return result;
    }

    public static FlowableTransformer<Binding, Binding> transformerFromQuery(Query query) {
        ExecutionContext execCxt = QueryFlowOps.createExecutionContextDefault();
        FlowableTransformer<Binding, Binding> result = QueryFlowOps.createTransformForGroupBy(query, (FunctionEnv)execCxt);
        return result;
    }

    public static <T> Flowable<T> wrapClosableIteratorSupplier(Supplier<? extends ClosableIterator<T>> itSupp) {
        return Flowable.generate(() -> (ClosableIterator)itSupp.get(), (it, emitter) -> {
            if (it.hasNext()) {
                Object item = it.next();
                emitter.onNext(item);
            } else {
                emitter.onComplete();
            }
        }, ClosableIterator::close);
    }

    public static Flowable<Triple> createFlowableFromGraph(Graph g, Triple pattern) {
        return QueryFlowOps.wrapClosableIteratorSupplier(() -> {
            ExtendedIterator r = g.find(pattern);
            return r;
        });
    }

    public static Function<Binding, Flowable<Binding>> createMapperForJoin(Graph graph, Triple triplePattern) {
        return binding -> {
            Triple substPattern = Substitute.substitute((Triple)triplePattern, (Binding)binding);
            Triple findPattern = QueryFlowOps.varToAny(substPattern);
            return QueryFlowOps.wrapClosableIteratorSupplier(() -> {
                ExtendedIterator r = graph.find(findPattern);
                return r;
            }).flatMapMaybe(contrib -> {
                BindingBuilder map = BindingFactory.builder((Binding)binding);
                Binding r = QueryFlowOps.mapper(map, substPattern, contrib);
                return r == null ? Maybe.empty() : Maybe.just((Object)r);
            });
        };
    }

    public static Function<Binding, Flowable<Binding>> createMapperForOptionalJoin(Graph graph, Triple triplePattern) {
        return binding -> {
            Triple substPattern = Substitute.substitute((Triple)triplePattern, (Binding)binding);
            Triple findPattern = QueryFlowOps.varToAny(substPattern);
            return QueryFlowOps.wrapClosableIteratorSupplier(() -> {
                ExtendedIterator r = graph.find(findPattern);
                return r;
            }).flatMapMaybe(contrib -> {
                BindingBuilder map = BindingFactory.builder((Binding)binding);
                Binding r = QueryFlowOps.mapper(map, substPattern, contrib);
                return r == null ? Maybe.empty() : Maybe.just((Object)r);
            }).defaultIfEmpty(binding);
        };
    }

    public static Node varToAny(Node node) {
        if (node.isVariable()) {
            return Node.ANY;
        }
        return node;
    }

    public static Triple varToAny(Triple tp) {
        Triple result = Triple.create((Node)QueryFlowOps.varToAny(tp.getSubject()), (Node)QueryFlowOps.varToAny(tp.getPredicate()), (Node)QueryFlowOps.varToAny(tp.getObject()));
        return result;
    }

    public static Binding mapper(BindingBuilder result, Triple pattern, Triple match) {
        if (!QueryFlowOps.insert(pattern.getMatchSubject(), match.getSubject(), result)) {
            return null;
        }
        if (!QueryFlowOps.insert(pattern.getMatchPredicate(), match.getPredicate(), result)) {
            return null;
        }
        if (!QueryFlowOps.insert(pattern.getMatchObject(), match.getObject(), result)) {
            return null;
        }
        return result.build();
    }

    public static boolean insert(Node inputNode, Node outputNode, BindingBuilder results) {
        if (!Var.isVar((Node)inputNode)) {
            return true;
        }
        Var v = Var.alloc((Node)inputNode);
        Node x = results.get(v);
        if (x != null) {
            return outputNode.equals((Object)x);
        }
        results.add(v, outputNode);
        return true;
    }

    public static Predicate<Binding> createFilter(Expr expr, FunctionEnv execCxt) {
        return binding -> expr.isSatisfied(binding, execCxt);
    }

    public static Predicate<Binding> createFilter(ExprList exprs, FunctionEnv execCxt) {
        return binding -> {
            Expr expr;
            boolean r = true;
            Iterator iterator = exprs.iterator();
            while (iterator.hasNext() && (r = (expr = (Expr)iterator.next()).isSatisfied(binding, execCxt))) {
            }
            return r;
        };
    }

    public static Predicate<Binding> createFilter(String exprStr, FunctionEnv execCxt) {
        Expr expr = ExprUtils.parse((String)exprStr);
        return QueryFlowOps.createFilter(expr, execCxt);
    }

    public static Predicate<Binding> createFilter(String exprStr, PrefixMapping pm, FunctionEnv execCxt) {
        Expr expr = ExprUtils.parse((String)exprStr, (PrefixMapping)pm);
        return QueryFlowOps.createFilter(expr, execCxt);
    }

    public static FlowableTransformer<Binding, Binding> createAssign(VarExprList exprs, FunctionEnv execCxt) {
        return upstream -> upstream.map(binding -> QueryFlowAssign.assign(binding, exprs, execCxt));
    }

    public static FlowableTransformer<Binding, Binding> createProject(Collection<Var> vars, FunctionEnv execCxt) {
        return upstream -> upstream.map(binding -> new BindingProject(vars, binding));
    }

    public static <T> FlowableTransformer<T, T> createSlice(Long offset, Long limit) {
        return upstream -> {
            if (offset != null && offset != Long.MIN_VALUE) {
                upstream = upstream.skip(offset.longValue());
            }
            if (limit != null && limit != Long.MIN_VALUE) {
                upstream = upstream.take(limit.longValue());
            }
            return upstream;
        };
    }

    public static FlowableTransformer<Binding, Binding> createTransformForGroupBy(Query query, FunctionEnv execCxt) {
        VarExprList groupVarExpr = query.getGroupBy();
        List aggregators = query.getAggregators();
        VarExprList rawProj = query.getProject();
        VarExprList vel = null;
        if (!query.isQueryResultStar()) {
            vel = new VarExprList();
            for (Var v : rawProj.getVars()) {
                Expr e = rawProj.getExpr(v);
                if (e != null) {
                    Expr e2 = ExprLib.replaceAggregateByVariable((Expr)e);
                    vel.add(v, e2);
                    continue;
                }
                vel.add(v);
            }
        }
        VarExprList finalVel = vel;
        List newScs = query.getOrderBy() == null ? Collections.emptyList() : query.getOrderBy().stream().map(sc -> new SortCondition(ExprLib.replaceAggregateByVariable((Expr)sc.getExpression()), sc.getDirection())).collect(Collectors.toList());
        FlowableTransformer result = upstream -> {
            Flowable r = upstream;
            if (!aggregators.isEmpty()) {
                r = r.compose(QueryFlowGroupBy.createTransformer(execCxt, groupVarExpr, aggregators));
            }
            if (finalVel != null) {
                r = r.compose(QueryFlowOps.createAssign(finalVel, execCxt));
            }
            if (!newScs.isEmpty()) {
                r = r.compose(QueryFlowOps.createOrderBy(newScs));
            }
            if (finalVel != null) {
                r = r.compose(QueryFlowOps.createProject(finalVel.getVars(), execCxt));
            }
            r = r.compose(QueryFlowOps.createSlice(query.getOffset(), query.getLimit()));
            return r;
        };
        return result;
    }

    public static FlowableTransformer<Binding, Binding> createOrderBy(List<SortCondition> sortConditions) {
        BindingComparator bindingCmp = new BindingComparator(sortConditions);
        return sortConditions.isEmpty() ? upstream -> upstream : arg_0 -> QueryFlowOps.lambda$createOrderBy$27((Comparator)bindingCmp, arg_0);
    }

    private static /* synthetic */ Publisher lambda$createOrderBy$27(Comparator bindingCmp, Flowable upstream) {
        return upstream.sorted(bindingCmp);
    }
}

