/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.query.rx;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;

public class FlowState<T> {
    protected InputStream in;
    protected Thread producerThread;
    protected Throwable raisedException;
    protected Iterator<T> iterator;
    protected volatile boolean closeInvoked;

    public Thread getProducerThread() {
        return this.producerThread;
    }

    public void setProducerThread(Thread thread) {
        this.producerThread = thread;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public void setIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public static boolean isRiotBrokenPipeException(Throwable t) {
        String msg;
        boolean result = false;
        if (t instanceof RiotException && ((msg = t.getMessage()).equalsIgnoreCase("Pipe closed") || msg.equals("Consumer Dead"))) {
            result = true;
        }
        return result;
    }

    public void handleProducerException(Thread thread, Throwable e) {
        boolean report = true;
        if (this.closeInvoked && (e instanceof RiotParseException || e instanceof CancellationException || FlowState.isRiotBrokenPipeException(e))) {
            report = false;
        }
        if (report) {
            if (this.raisedException == null) {
                this.raisedException = e;
            }
            if (this.closeInvoked) {
                throw new RuntimeException(e);
            }
        }
    }

    public void close() throws IOException {
        this.closeInvoked = true;
        try {
            this.in.close();
        }
        finally {
            try {
                if (this.iterator instanceof java.io.Closeable) {
                    ((java.io.Closeable)((Object)this.iterator)).close();
                } else if (this.iterator instanceof Closeable) {
                    ((Closeable)this.iterator).close();
                }
            }
            finally {
                FlowState.interruptUntilDead(this.producerThread);
            }
        }
    }

    public static void interruptUntilDead(Thread thread) {
        if (thread != null) {
            while (thread.isAlive()) {
                thread.interrupt();
                try {
                    thread.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

